/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean;

import com.pengrad.telegrambot.TelegramBot;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.bean.TelegramBotBean;
import systems.dennis.flaw.bean.populate.GroupPopulate;
import systems.dennis.flaw.bean.populate.GroupTypePopulate;
import systems.dennis.flaw.bean.populate.HrPopulate;
import systems.dennis.flaw.bean.populate.LanguagePopulate;
import systems.dennis.flaw.bean.populate.PopulateDispatcher;
import systems.dennis.flaw.model.GroupTypeModel;
import systems.dennis.flaw.repo.GroupRepo;
import systems.dennis.flaw.repo.GroupTypeRepo;
import systems.dennis.flaw.repo.HRRepo;
import systems.dennis.flaw.service.GroupTypeService;
import systems.dennis.shared.beans.OnAppStart;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.LanguageRepo;
import systems.dennis.shared.repository.PaginationRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@Component
public class OnAppStartsFlaw
extends ApplicationContext
implements OnAppStart {
    private static final Logger log = LoggerFactory.getLogger(OnAppStartsFlaw.class);
    public static final String ENABLE_TELEGRAM_BOT = "enable.telegram.bot";
    public static final String BOT_TELEGRAM_KEY = "bot.telegram.key";
    private final List<PopulateDispatcher> populateDispatchers;

    public OnAppStartsFlaw(WebContext context, List<PopulateDispatcher> populateDispatchers) {
        super(context);
        this.populateDispatchers = populateDispatchers;
    }

    public void onAppRun(WebContext context) {
        log.info("Application started");
        TelegramBotBean telegramBotProcessor = (TelegramBotBean)context.getBean(TelegramBotBean.class);
        WebContext.LocalWebContext localWebContext = this.getContext();
        this.initializePopulateDispatchers(localWebContext);
        if (this.isEnableBot()) {
            TelegramBot tb = new TelegramBot(this.getBotKey());
            ((TelegramBotBean)context.getBean(TelegramBotBean.class)).assignTelegramBot(tb);
            tb.setUpdatesListener(arg_0 -> ((TelegramBotBean)telegramBotProcessor).onUpdate(arg_0));
        }
        for (PopulateDispatcher populateDispatcher : this.populateDispatchers) {
            if (!populateDispatcher.shouldPopulate()) continue;
            populateDispatcher.populate();
        }
        this.addGroupTypes();
    }

    private void initializePopulateDispatchers(WebContext.LocalWebContext context) {
        this.populateDispatchers.add(new LanguagePopulate().init(null, context, (PaginationRepository)this.getBean(LanguageRepo.class), null, null));
        this.populateDispatchers.add(new GroupTypePopulate().init(null, context, (PaginationRepository)this.getBean(GroupTypeRepo.class), null, null));
        this.populateDispatchers.add(new HrPopulate().init(null, context, (PaginationRepository)this.getBean(HRRepo.class), null, null));
        this.populateDispatchers.add(new GroupPopulate().init(null, context, (PaginationRepository)this.getBean(GroupRepo.class), null, null));
    }

    private void addGroupTypes() {
        this.addGroupTypeIfNotExist("Development");
        this.addGroupTypeIfNotExist("HR");
        this.addGroupTypeIfNotExist("Document Flow");
        this.addGroupTypeIfNotExist("Support");
        this.addGroupTypeIfNotExist("Empty");
    }

    private void addGroupTypeIfNotExist(String groupName) {
        if (!this.isGroupTypeExist(groupName)) {
            GroupTypeModel groupType = new GroupTypeModel();
            groupType.setName(groupName);
            ((GroupTypeService)this.getBean(GroupTypeService.class)).save((BaseEntity)groupType);
        }
    }

    private boolean isGroupTypeExist(String name) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"name", (Object)name).specification();
        return ((GroupTypeRepo)this.getBean(GroupTypeRepo.class)).count((Specification)specification) > 0L;
    }

    public boolean isEnableBot() {
        return (Boolean)this.getContext().getEnv(ENABLE_TELEGRAM_BOT, (Object)true);
    }

    public String getBotKey() {
        return (String)this.getContext().getEnv(BOT_TELEGRAM_KEY, null);
    }
}

