/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean;

import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.model.request.ParseMode;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.SendMessage;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.exception.TelegramFlawException;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.MyService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.flaw.service.issue.change_processors.TelegramBotProcessor;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;

@Service
public class TelegramBotBean {
    public IssueService service;
    private MyService myService;
    private GroupService groupService;
    private TelegramBot bot;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;
    @Value(value="${app.settings.site.self.ui}")
    private String baseUrl;
    public static final String ISSUE_VIEW_URL = "pages/issue/view/?id=";

    public TelegramBotBean(IssueService service, MyService myService, GroupService groupService) {
        this.service = service;
        this.myService = myService;
        this.groupService = groupService;
    }

    public void assignTelegramBot(TelegramBot bot) {
        this.bot = bot;
    }

    public boolean isActive() {
        return this.bot != null;
    }

    public int onUpdate(List<Update> updates) {
        for (Update update : updates) {
            try {
                String param;
                long id = this.chatId(update);
                String author = this.author(update);
                if (this.isMessageSelected(update, "me")) {
                    this.bot.execute((BaseRequest)this.m(id, "" + this.chatId(update)));
                }
                if ((param = this.ifMessageSelectedReturnParameter(update, "take")) != null) {
                    try {
                        this.takeIssue(Long.valueOf(param.trim()), update);
                    }
                    catch (Exception e) {
                        this.bot.execute((BaseRequest)this.m(id, "Cannot take this issue: " + e.getMessage()));
                    }
                    this.bot.execute((BaseRequest)this.m(id, "command success:: " + author + " " + param));
                    continue;
                }
                param = this.ifMessageSelectedReturnParameter(update, "status");
                if (param != null) {
                    String[] items = param.split("to");
                    if (items.length == 0) {
                        throw new TelegramFlawException("Command should be /status ID to STATUS_NAME ");
                    }
                    try {
                        this.setStatus(Long.valueOf(items[0].trim()), items[1].trim(), update);
                    }
                    catch (Exception e) {
                        this.bot.execute((BaseRequest)this.m(id, "Cannot take this issue: " + e.getMessage()));
                    }
                    this.bot.execute((BaseRequest)this.m(id, "command success:: " + author + " " + param));
                    continue;
                }
                param = this.ifMessageSelectedReturnParameter(update, "my");
                if (param == null) continue;
                HRModel performer = this.myService.findByTelegramId(author);
                List issueModels = this.service.getLastFiveIssuesByPerformer(performer, this.em);
                StringBuilder message = new StringBuilder();
                message.append("Your issues: \n");
                for (IssueModel issue : issueModels) {
                    message.append((CharSequence)this.generateMessageToCommandMy(issue));
                }
                if (issueModels.size() == 0) {
                    this.bot.execute((BaseRequest)this.m(id, "You don't have any tasks right now"));
                    continue;
                }
                this.bot.execute((BaseRequest)this.m(id, String.valueOf(message)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public void sendMessage(GroupModel groupModel, String text) {
        if (this.bot == null) {
            return;
        }
        if (groupModel.getTelegramId() == null || groupModel.getTelegramId() == 0L) {
            throw new TelegramFlawException("Chat not set for the group");
        }
        this.bot.execute((BaseRequest)this.m(groupModel.getTelegramId().longValue(), text.replaceAll("_", "\\_")));
    }

    private void setStatus(Long valueOf, String status, Update update) {
        IssueModel issue = this.validate(valueOf, update);
        HRModel hr = this.hr(update);
        IssueStatusModel statusObj = (IssueStatusModel)this.findStatusByName(status).orElseThrow(() -> new TelegramFlawException("Status with name: " + status + " not found in system or has 2 or more same named records"));
        if (Objects.equals(statusObj, issue.getStatus())) {
            throw new TelegramFlawException("Issue is already in this status");
        }
        this.service.setStatusEx(issue, statusObj, hr);
    }

    private void takeIssue(Long valueOf, Update update) {
        IssueModel issue = this.validate(valueOf, update);
        HRModel hr = this.hr(update);
        if (Objects.equals(issue.getPerformer(), hr)) {
            throw new TelegramFlawException("Issue had already you as assigned");
        }
        issue.setPerformer(hr);
        this.service.save((BaseEntity)issue);
    }

    HRModel hr(Update update) {
        String author = this.author(update);
        if (author == null) {
            throw new TelegramFlawException("You have no nick name in Telegram. We are not able to proceed");
        }
        return (HRModel)this.findHrByTelegram(author).orElseThrow(() -> new ItemNotFoundException("No user found for this name " + author));
    }

    IssueModel validate(Long valueOf, Update update) {
        IssueModel issue = (IssueModel)this.issueById(valueOf).orElseThrow(() -> new ItemNotFoundException(valueOf));
        long chat = this.chatId(update);
        GroupModel group = (GroupModel)this.findGroupByTelegram(Long.valueOf(chat)).orElseThrow(() -> new ItemNotFoundException("No group registered for this chat"));
        if (issue.getGroup() == null || issue.getGroup().getTelegramId() == null || !issue.getGroup().getTelegramId().equals(group.getTelegramId())) {
            throw new TelegramFlawException("Group is not assigned to chat, or Issue doesn't belong to group of chat");
        }
        return issue;
    }

    SendMessage m(long id, String text) {
        SendMessage message = new SendMessage((Object)id, text).parseMode(ParseMode.HTML);
        return message;
    }

    long chatId(Update update) {
        return update.message().chat().id();
    }

    boolean isMessageSelected(Update message, String text) {
        if (message.message() == null || message.message().text() == null) {
            return false;
        }
        return message.message().text().equals("/" + text);
    }

    String author(Update update) {
        return update.message().from().username();
    }

    String ifMessageSelectedReturnParameter(Update message, String text) {
        if (message.message() == null || message.message().text() == null) {
            return null;
        }
        if (message.message().text().contains("/" + text)) {
            return message.message().text().replaceAll("/" + text, "");
        }
        return null;
    }

    Optional<HRModel> findHrByTelegram(String telegram) {
        try {
            return Optional.of((HRModel)this.em.createQuery("select u from HRModel u where u.telegramName = :telegram").setParameter("telegram", (Object)telegram).getSingleResult());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    Optional<GroupModel> findGroupByTelegram(Long telegram) {
        try {
            return Optional.of((GroupModel)this.em.createQuery("select u from GroupModel u where u.telegramId = :telegram").setParameter("telegram", (Object)telegram).getSingleResult());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    Optional<IssueStatusModel> findStatusByName(String status) {
        try {
            return Optional.of((IssueStatusModel)this.em.createQuery("select u from IssueStatusModel u where u.name = :status").setParameter("status", (Object)status.trim()).getSingleResult());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    Optional<IssueModel> issueById(Long id) {
        try {
            return Optional.of((IssueModel)this.em.createQuery("select u from IssueModel u where u.id = :id").setParameter("id", (Object)id).getSingleResult());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public StringBuilder generateMessageToCommandMy(IssueModel issue) {
        StringBuilder message = new StringBuilder();
        message.append("\n");
        message.append("<a href='").append(this.baseUrl).append(ISSUE_VIEW_URL).append(issue.getId()).append("'>Issue: ID").append(issue.getId()).append("</a> \n");
        if (issue.getPriority() != null) {
            message.append("Priority: ").append(issue.getPriority().getName()).append("\n");
        } else {
            message.append("Priority: ").append("Not set").append("\n");
        }
        if (issue.getCreated() != null) {
            message.append("Created: ").append(TelegramBotProcessor.dateToString((Date)issue.getCreated())).append("\n");
        } else {
            message.append("Created: ").append("Not set").append("\n");
        }
        if (issue.getStatus() != null) {
            message.append("Status: ").append(issue.getStatus().getName()).append("\n");
        } else {
            message.append("Status: ").append("Not set").append("\n");
        }
        if (issue.getCreator() != null) {
            String creatorTg = TelegramBotProcessor.createTelegramUser((HRModel)issue.getCreator());
            message.append("Creator: ").append(creatorTg).append("\n");
        } else {
            message.append("Creator: ").append("Not set").append("\n");
        }
        if (issue.getPerformer() != null) {
            String performerTg = TelegramBotProcessor.createTelegramUser((HRModel)issue.getPerformer());
            message.append("Performer: ").append(performerTg).append("\n");
        } else {
            message.append("Performer: ").append("Not set").append("\n");
        }
        if (issue.getTester() != null) {
            String testerTg = TelegramBotProcessor.createTelegramUser((HRModel)issue.getTester());
            message.append("Tester: ").append(testerTg).append("\n");
        } else {
            message.append("Tester: ").append("Not set").append("\n");
        }
        if (issue.getProject() != null) {
            message.append("Project: ").append(issue.getProject().getName()).append("\n");
        } else {
            message.append("Project: ").append("Not set").append("\n");
        }
        return message;
    }
}

