/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.flaw.bean.populate.PopulateDispatcher;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupTypeModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.model.LanguageModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.PaginationRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

public abstract class AbstractPopulateDispatcher<T extends BaseEntity>
implements PopulateDispatcher<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPopulateDispatcher.class);
    public static final String GROUP_TYPE_DEVELOPMENT = "Development";
    public static final String GROUP_TYPE_HR = "HR";
    public static final String GROUP_TYPE_DOCUMENT_FLOW = "Document Flow";
    public static final String GROUP_TYPE_SUPPORT = "Support";
    public static final String GROUP_TYPE_EMPTY = "Empty";
    private GroupModel group;
    private WebContext.LocalWebContext context;
    private PaginationRepository<T> repository;
    private PaginationService<T> service;
    private LanguageModel language;
    private GroupTypeModel groupType;
    private HRModel hr;

    public AbstractPopulateDispatcher<T> init(GroupModel model, WebContext.LocalWebContext context, PaginationRepository<T> repository, LanguageModel language, GroupTypeModel groupType) {
        this.group = model;
        this.context = context;
        this.repository = repository;
        this.language = language;
        this.groupType = groupType;
        return this;
    }

    public AbstractPopulateDispatcher<T> setHR(HRModel model) {
        this.hr = model;
        return this;
    }

    public boolean shouldPopulate() {
        return this.repository.count((Specification)QueryCase.equalsOf((String)"group", (Object)this.group).specification()) > 0L;
    }

    public void deleteDemo() {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"demo", (Object)true).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.group)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()));
        List models = this.repository.findAll((Specification)specification);
        this.preDeleteDemo(models);
        for (BaseEntity model : models) {
            try {
                this.repository.delete((Object)model);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public String getDemoData() {
        return this.groupType.getClass().getSimpleName() + ":" + this.groupType.getId();
    }

    public boolean isDemoExist(String name) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"name", (Object)name).specification().addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"group", (Object)this.group)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()));
        return this.repository.count((Specification)specification) > 0L;
    }

    public void preDeleteDemo(List<T> models) {
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public WebContext.LocalWebContext getContext() {
        return this.context;
    }

    public PaginationRepository<T> getRepository() {
        return this.repository;
    }

    public PaginationService<T> getService() {
        return this.service;
    }

    public LanguageModel getLanguage() {
        return this.language;
    }

    public GroupTypeModel getGroupType() {
        return this.groupType;
    }

    public HRModel getHr() {
        return this.hr;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setContext(WebContext.LocalWebContext context) {
        this.context = context;
    }

    public void setRepository(PaginationRepository<T> repository) {
        this.repository = repository;
    }

    public void setService(PaginationService<T> service) {
        this.service = service;
    }

    public void setLanguage(LanguageModel language) {
        this.language = language;
    }

    public void setGroupType(GroupTypeModel groupType) {
        this.groupType = groupType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPopulateDispatcher)) {
            return false;
        }
        AbstractPopulateDispatcher other = (AbstractPopulateDispatcher)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        WebContext.LocalWebContext this$context = this.getContext();
        WebContext.LocalWebContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        PaginationRepository this$repository = this.getRepository();
        PaginationRepository other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        PaginationService this$service = this.getService();
        PaginationService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        LanguageModel this$language = this.getLanguage();
        LanguageModel other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        GroupTypeModel this$groupType = this.getGroupType();
        GroupTypeModel other$groupType = other.getGroupType();
        if (this$groupType == null ? other$groupType != null : !this$groupType.equals(other$groupType)) {
            return false;
        }
        HRModel this$hr = this.getHr();
        HRModel other$hr = other.getHr();
        return !(this$hr == null ? other$hr != null : !this$hr.equals(other$hr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractPopulateDispatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        WebContext.LocalWebContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        PaginationRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        PaginationService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        LanguageModel $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        GroupTypeModel $groupType = this.getGroupType();
        result = result * 59 + ($groupType == null ? 43 : $groupType.hashCode());
        HRModel $hr = this.getHr();
        result = result * 59 + ($hr == null ? 43 : $hr.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractPopulateDispatcher(group=" + String.valueOf(this.getGroup()) + ", context=" + String.valueOf(this.getContext()) + ", repository=" + String.valueOf(this.getRepository()) + ", service=" + String.valueOf(this.getService()) + ", language=" + String.valueOf(this.getLanguage()) + ", groupType=" + String.valueOf(this.getGroupType()) + ", hr=" + String.valueOf(this.getHr()) + ")";
    }
}

