/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.bean.populate.SOURCES;
import systems.dennis.flaw.model.EpicStatusModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.shared.config.WebContext;

public class EpicStatusPopulate
extends AbstractPopulateDispatcher<EpicStatusModel> {
    public static final String ICON_PATH_PREFIX = "img/status.";
    public static final String ICON_PATH_SUFFIX = ".png";
    public static final String EPIC_STATUS_NAME_KEY = "epicstatus.name.";
    public static final String EPIC_STATUS_NONE = "none";
    public static final String EPIC_STATUS_TO_DO = "to_do";
    private static final String EPIC_STATUS_IN_PROGRESS = "in_progress";
    private static final String EPIC_STATUS_DONE = "done";

    public void populate() {
        List models = this.createEpicStatusModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<EpicStatusModel> createEpicStatusModels() {
        ArrayList<EpicStatusModel> models = new ArrayList<EpicStatusModel>();
        GroupModel groupModel = this.getGroup();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, EPIC_STATUS_NONE, groupModel);
        this.addToModelsIfNotExists(models, EPIC_STATUS_TO_DO, groupModel);
        this.addToModelsIfNotExists(models, EPIC_STATUS_IN_PROGRESS, groupModel);
        this.addToModelsIfNotExists(models, EPIC_STATUS_DONE, groupModel);
        return models;
    }

    private void addToModelsIfNotExists(List<EpicStatusModel> models, String name, GroupModel groupModel) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createEpicStatusModel(name, groupModel));
        }
    }

    private EpicStatusModel createEpicStatusModel(String statusName, GroupModel groupModel) {
        EpicStatusModel model = new EpicStatusModel();
        model.setName(this.getNameTranslation(statusName));
        model.setIcon(SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)(ICON_PATH_PREFIX + statusName + ICON_PATH_SUFFIX)));
        model.setGroup(groupModel);
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String statusName) {
        return this.getContext().getMessageTranslation(EPIC_STATUS_NAME_KEY + statusName, this.getLanguage().getCode());
    }
}

