/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.repo.GroupRepo;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.shared.entity.BaseEntity;

public class GroupPopulate
extends AbstractPopulateDispatcher<GroupModel> {
    public void populate() {
        GroupService groupService = (GroupService)this.getContext().getBean(GroupService.class);
        GroupModel model = this.createGroupModel();
        groupService.save((BaseEntity)model);
    }

    public boolean shouldPopulate() {
        GroupRepo repo = (GroupRepo)this.getContext().getBean(GroupRepo.class);
        return repo.count() == 0L;
    }

    private GroupModel createGroupModel() {
        long remoteId = 1L;
        String userLanguage = "en";
        if (this.getHr() != null) {
            if (this.getHr().getRemoteId() != null) {
                remoteId = this.getHr().getRemoteId();
            } else if (this.getHr().getUserDataId() != null) {
                remoteId = this.getHr().getUserDataId();
            }
        }
        if (this.getHr() != null && this.getHr().getDefLanguage() != null) {
            userLanguage = this.getHr().getDefLanguage();
        }
        GroupModel model = new GroupModel();
        model.setName(this.getNameTranslation(userLanguage));
        model.setUserDataId(Long.valueOf(remoteId));
        return model;
    }

    private String getNameTranslation(String language) {
        return this.getContext().getMessageTranslation("group.name.default", language);
    }
}

