/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueTypeModel;
import systems.dennis.flaw.repo.BoardRepo;
import systems.dennis.flaw.repo.IssueFlowRepo;
import systems.dennis.flaw.repo.IssueTypeRepo;
import systems.dennis.flaw.service.BoardService;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;

public class IssueFlowPopulate
extends AbstractPopulateDispatcher<IssueFlowModel> {
    public void populate() {
        IssueFlowRepo repo = (IssueFlowRepo)this.getContext().getBean(IssueFlowRepo.class);
        List models = this.createIssueFlowModels();
        if (!models.isEmpty()) {
            repo.saveAll((Iterable)models);
        }
    }

    public boolean shouldPopulate() {
        IssueFlowRepo repo = (IssueFlowRepo)this.getContext().getBean(IssueFlowRepo.class);
        return repo.count() == 0L;
    }

    private List<IssueFlowModel> createIssueFlowModels() {
        ArrayList<IssueFlowModel> models = new ArrayList<IssueFlowModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        if (groupType.equalsIgnoreCase("Development")) {
            this.createDevelopmentFlow(models);
        }
        if (groupType.equalsIgnoreCase("HR")) {
            this.createHrFlow(models);
        }
        if (groupType.equalsIgnoreCase("Document Flow")) {
            this.createDocumentFlow(models);
        }
        if (groupType.equalsIgnoreCase("Support")) {
            this.createSupportFlow(models);
        }
        return models;
    }

    private void createDevelopmentFlow(List<IssueFlowModel> models) {
        this.addToModelsIfNotExists(models, "bug", this.findIssueTypeByName("bug"));
        this.addToModelsIfNotExists(models, "task", this.findIssueTypeByName("task"));
        this.addToModelsIfNotExists(models, "quick", this.findIssueTypeByName("bug"));
    }

    private void createHrFlow(List<IssueFlowModel> models) {
        this.addToModelsIfNotExists(models, "employee_termination", this.findIssueTypeByName("employee_termination"));
        this.addToModelsIfNotExists(models, "hiring", this.findIssueTypeByName("hiring"));
    }

    private void createDocumentFlow(List<IssueFlowModel> models) {
        this.addToModelsIfNotExists(models, "order", this.findIssueTypeByName("order"));
        this.addToModelsIfNotExists(models, "assignment", this.findIssueTypeByName("assignment"));
        this.addToModelsIfNotExists(models, "incoming_letter", this.findIssueTypeByName("incoming_letter"));
        this.addToModelsIfNotExists(models, "outgoing_letter", this.findIssueTypeByName("outgoing_letter"));
    }

    private void createSupportFlow(List<IssueFlowModel> models) {
        this.addToModelsIfNotExists(models, "request", this.findIssueTypeByName("request"));
    }

    private void addToModelsIfNotExists(List<IssueFlowModel> models, String name, IssueTypeModel issueTypeModel) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createIssueFlowModel(name, issueTypeModel));
        }
    }

    private IssueFlowModel createIssueFlowModel(String name, IssueTypeModel issueTypeModel) {
        IssueFlowModel model = new IssueFlowModel();
        model.setName(this.getNameTranslation(name));
        model.setIssueType(issueTypeModel);
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private IssueTypeModel findIssueTypeByName(String name) {
        IssueTypeRepo repo = (IssueTypeRepo)this.getContext().getBean(IssueTypeRepo.class);
        return (IssueTypeModel)repo.findOne((Specification)QueryCase.equalsOf((String)"name", (Object)this.getTypeTranslation(name)).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()))).orElseThrow(() -> new ItemNotFoundException(name));
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("issueflow.name." + key, this.getLanguage().getCode());
    }

    private String getTypeTranslation(String key) {
        return this.getContext().getMessageTranslation("issuetype.name." + key, this.getLanguage().getCode());
    }

    public void preDeleteDemo(List<IssueFlowModel> models) {
        for (IssueFlowModel model : models) {
            DefaultSearchSpecification specification = QueryCase.equalsOf((String)"flow", (Object)model).specification().addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()));
            ((BoardRepo)this.getContext().getBean(BoardRepo.class)).findOne((Specification)specification).ifPresent(board -> ((BoardService)this.getContext().getBean(BoardService.class)).delete(board.getId()));
        }
    }
}

