/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.BoardModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.repo.IssueFlowRepo;
import systems.dennis.flaw.repo.IssueStatusRepo;
import systems.dennis.flaw.service.IssueFlowService;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;

public class IssueFlowStagePopulate
extends AbstractPopulateDispatcher<IssueFlowStageModel> {
    public void populate() {
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return;
        }
        if (groupType.equalsIgnoreCase("Development")) {
            this.createDevelopmentFlowStage();
        }
        if (groupType.equalsIgnoreCase("HR")) {
            this.createHrFlowStage();
        }
        if (groupType.equalsIgnoreCase("Document Flow")) {
            this.createDocumentFlowStage();
        }
        if (groupType.equalsIgnoreCase("Support")) {
            this.createSupportFlowStage();
        }
    }

    private void createDevelopmentFlowStage() {
        List bugIssueFlowStageModels = this.createBugIssueFlowStageModels();
        this.addFlowStageToFlow("bug", bugIssueFlowStageModels);
        List createTaskIssueFlowStageModels = this.createTaskIssueFlowStageModels();
        this.addFlowStageToFlow("task", createTaskIssueFlowStageModels);
        List createQuickIssueFlowStageModels = this.createQuickIssueFlowStageModels();
        this.addFlowStageToFlow("quick", createQuickIssueFlowStageModels);
    }

    private void createHrFlowStage() {
        List employeeTerminationStages = this.createEmployeeTerminationFlowStageModels();
        this.addFlowStageToFlow("employee_termination", employeeTerminationStages);
        List hiringStages = this.createHiringFlowStageModels();
        this.addFlowStageToFlow("hiring", hiringStages);
    }

    private void createDocumentFlowStage() {
        List orderStages = this.createOrderFlowStageModels();
        this.addFlowStageToFlow("order", orderStages);
        List assignmentStages = this.createAssignmentIssueFlowStageModels();
        this.addFlowStageToFlow("assignment", assignmentStages);
        List incomingLetterStages = this.createIncomingLetterFlowStageModels();
        this.addFlowStageToFlow("incoming_letter", incomingLetterStages);
        List outgoingLetterStages = this.createOutgoingLetterFlowStageModels();
        this.addFlowStageToFlow("outgoing_letter", outgoingLetterStages);
    }

    private void createSupportFlowStage() {
        List requestStages = this.createRequestFlowStageModels();
        this.addFlowStageToFlow("request", requestStages);
    }

    private List<IssueFlowStageModel> createQuickIssueFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "created", "in_progress"));
        models.add(this.createIssueFlowStageModel("created", "in_progress", "to_test"));
        models.add(this.createIssueFlowStageModel("reopened", "to_test", "tested"));
        models.add(this.createIssueFlowStageModel("created", "reopened", "in_progress"));
        models.add(this.createIssueFlowStageModel("to_test", "tested", "closed"));
        models.add(this.createIssueFlowStageModel("tested", "closed", null));
        return models;
    }

    private List<IssueFlowStageModel> createBugIssueFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "created", "in_progress"));
        models.add(this.createIssueFlowStageModel("created", "in_progress", "done"));
        models.add(this.createIssueFlowStageModel("in_progress", "done", "to_test"));
        models.add(this.createIssueFlowStageModel("done", "to_test", "in_test"));
        models.add(this.createIssueFlowStageModel("reopened", "in_test", "tested"));
        models.add(this.createIssueFlowStageModel("created", "reopened", "in_progress"));
        models.add(this.createIssueFlowStageModel("reopened", "tested", "deployed"));
        models.add(this.createIssueFlowStageModel("in_test", "deployed", "closed"));
        models.add(this.createIssueFlowStageModel("deployed", "closed", null));
        return models;
    }

    private List<IssueFlowStageModel> createTaskIssueFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "created", "in_progress"));
        models.add(this.createIssueFlowStageModel("created", "in_progress", "done"));
        models.add(this.createIssueFlowStageModel("reopened", "done", null));
        models.add(this.createIssueFlowStageModel("created", "reopened", "in_progress"));
        return models;
    }

    private List<IssueFlowStageModel> createEmployeeTerminationFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "initiated", "signed"));
        models.add(this.createIssueFlowStageModel("cancelled", "signed", "account_termination_process"));
        models.add(this.createIssueFlowStageModel(null, "account_termination_process", "transferred_to_accounting"));
        models.add(this.createIssueFlowStageModel(null, "transferred_to_accounting", "accounting_termination_transaction"));
        return models;
    }

    private List<IssueFlowStageModel> createHiringFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "application_form_received", "application_form_review"));
        models.add(this.createIssueFlowStageModel("rejected", "application_form_review", "hr_interview"));
        models.add(this.createIssueFlowStageModel("rejected", "hr_interview", "technical_interview"));
        models.add(this.createIssueFlowStageModel("rejected", "technical_interview", "group_interview"));
        models.add(this.createIssueFlowStageModel("rejected", "group_interview", "contract_creation"));
        models.add(this.createIssueFlowStageModel("rejected", "contract_creation", "contract_signing"));
        models.add(this.createIssueFlowStageModel("rejected", "contract_signing", "starting_employment"));
        models.add(this.createIssueFlowStageModel("rejected", "starting_employment", "closed"));
        return models;
    }

    private List<IssueFlowStageModel> createOrderFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "initiated", "under_review"));
        models.add(this.createIssueFlowStageModel("under_revision", "under_approval", "in_signing"));
        models.add(this.createIssueFlowStageModel("under_revision", "in_signing", "signed"));
        models.add(this.createIssueFlowStageModel("cancelled", "for_information", "archived"));
        models.add(this.createIssueFlowStageModel(null, "archived", "cancelled"));
        return models;
    }

    private List<IssueFlowStageModel> createAssignmentIssueFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "created", "in_progress"));
        models.add(this.createIssueFlowStageModel("created", "in_progress", "done"));
        models.add(this.createIssueFlowStageModel("reopened", "done", null));
        models.add(this.createIssueFlowStageModel("created", "reopened", "in_progress"));
        return models;
    }

    private List<IssueFlowStageModel> createIncomingLetterFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "received", "under_control"));
        models.add(this.createIssueFlowStageModel("archived", "under_control", "in_progress"));
        models.add(this.createIssueFlowStageModel("no_action_required", "in_progress", "response_approved"));
        models.add(this.createIssueFlowStageModel("no_action_required", "response_approved", "archived"));
        return models;
    }

    private List<IssueFlowStageModel> createOutgoingLetterFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "created", "under_review"));
        models.add(this.createIssueFlowStageModel("under_revision", "under_review", "in_signing"));
        models.add(this.createIssueFlowStageModel("under_revision", "in_signing", "signed"));
        models.add(this.createIssueFlowStageModel("under_revision", "signed", "archived"));
        models.add(this.createIssueFlowStageModel("cancelled", "under_revision", "under_review"));
        return models;
    }

    private List<IssueFlowStageModel> createRequestFlowStageModels() {
        ArrayList<IssueFlowStageModel> models = new ArrayList<IssueFlowStageModel>();
        models.add(this.createIssueFlowStageModel(null, "received", "under_control"));
        models.add(this.createIssueFlowStageModel("archived", "under_control", "in_progress"));
        models.add(this.createIssueFlowStageModel("no_action_required", "in_progress", "response_approved"));
        models.add(this.createIssueFlowStageModel(null, "in_progress", "awaiting_response"));
        models.add(this.createIssueFlowStageModel("sent_back", "awaiting_response", "closed"));
        return models;
    }

    private void addFlowStageToFlow(String name, List<IssueFlowStageModel> issueFlowStageModels) {
        IssueFlowRepo issueFlowRepo = (IssueFlowRepo)this.getContext().getBean(IssueFlowRepo.class);
        IssueFlowModel issueFlowModel = this.findByIssueFlowName(name);
        if (Objects.isNull(issueFlowModel.getStages()) || issueFlowModel.getStages().isEmpty()) {
            issueFlowModel.setStages(issueFlowStageModels);
            issueFlowModel = (IssueFlowModel)issueFlowRepo.save((Object)issueFlowModel);
        }
        if (!this.getGroupType().getName().equalsIgnoreCase("HR")) {
            BoardModel board = new BoardModel();
            board.setDemo(Boolean.valueOf(true));
            board.setDemoData(this.getDemoData());
            ((IssueFlowService)this.getContext().getBean(IssueFlowService.class)).generateAndSaveBoard(issueFlowModel, board);
        }
    }

    private IssueFlowStageModel createIssueFlowStageModel(String prev, String current, String next) {
        IssueFlowStageModel model = new IssueFlowStageModel();
        model.setPrevStatus(this.findByIssueStatusName(prev));
        model.setCurrentStatus(this.findByIssueStatusName(current));
        model.setNexStatus(this.findByIssueStatusName(next));
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private IssueStatusModel findByIssueStatusName(String name) {
        if (Objects.isNull(name)) {
            return null;
        }
        String status = this.getStatusTranslation(name);
        IssueStatusRepo repo = (IssueStatusRepo)this.getContext().getBean(IssueStatusRepo.class);
        return (IssueStatusModel)repo.findOne((Specification)QueryCase.equalsOf((String)"name", (Object)status).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()))).orElseThrow(() -> new ItemNotFoundException(status));
    }

    private IssueFlowModel findByIssueFlowName(String name) {
        String issueFlow = this.getIssueFlowTranslation(name);
        IssueFlowRepo issueFlowRepo = (IssueFlowRepo)this.getContext().getBean(IssueFlowRepo.class);
        return (IssueFlowModel)issueFlowRepo.findOne((Specification)QueryCase.equalsOf((String)"name", (Object)issueFlow).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()))).orElseThrow(() -> new ItemNotFoundException(issueFlow));
    }

    private String getStatusTranslation(String key) {
        return this.getContext().getMessageTranslation("issuestatus.name." + key, this.getLanguage().getCode());
    }

    private String getIssueFlowTranslation(String key) {
        return this.getContext().getMessageTranslation("issueflow.name." + key, this.getLanguage().getCode());
    }
}

