/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.IssueLinkTypeModel;

public class IssueLinkTypePopulate
extends AbstractPopulateDispatcher<IssueLinkTypeModel> {
    public void populate() {
        List models = this.createProjectStatusModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<IssueLinkTypeModel> createProjectStatusModels() {
        ArrayList<IssueLinkTypeModel> models = new ArrayList<IssueLinkTypeModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, "blocked");
        this.addToModelsIfNotExists(models, "blocked_by");
        this.addToModelsIfNotExists(models, "duplicated");
        return models;
    }

    private void addToModelsIfNotExists(List<IssueLinkTypeModel> models, String name) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createIssueLinkTypeModel(name));
        }
    }

    private IssueLinkTypeModel createIssueLinkTypeModel(String name) {
        IssueLinkTypeModel model = new IssueLinkTypeModel();
        model.setName(this.getNameTranslation(name));
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("issuelinktype.name." + key, this.getLanguage().getCode());
    }
}

