/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.bean.populate.SOURCES;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.shared.config.WebContext;

public class IssueStatusPopulate
extends AbstractPopulateDispatcher<IssueStatusModel> {
    public void populate() {
        List models = this.createIssueStatusModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<IssueStatusModel> createIssueStatusModels() {
        ArrayList<IssueStatusModel> models = new ArrayList<IssueStatusModel>();
        GroupModel groupModel = this.getGroup();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        if (groupType.equalsIgnoreCase("Development")) {
            this.createDevelopmentIssueStatus(models, groupModel);
        }
        if (groupType.equalsIgnoreCase("HR")) {
            this.createHRIssueStatus(models, groupModel);
        }
        if (groupType.equalsIgnoreCase("Document Flow")) {
            this.createDocumentFlowStatus(models, groupModel);
        }
        if (groupType.equalsIgnoreCase("Support")) {
            this.createSupportFlowStatus(models, groupModel);
        }
        return models;
    }

    private void createDevelopmentIssueStatus(List<IssueStatusModel> models, GroupModel groupModel) {
        this.addToModelsIfNotExists(models, "created", "created", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "reopened", "reopened", groupModel, "#ffe9f2", Integer.valueOf(5));
        this.addToModelsIfNotExists(models, "in_progress", "in_progress", groupModel, "#ffede8", Integer.valueOf(3));
        this.addToModelsIfNotExists(models, "in_test", "in_test", groupModel, "ebe9fe", Integer.valueOf(4));
        this.addToModelsIfNotExists(models, "tested", "tested", groupModel, "#f3e3fc", null);
        this.addToModelsIfNotExists(models, "to_test", "to_test", groupModel, "#fce0fb", Integer.valueOf(3));
        this.addToModelsIfNotExists(models, "deployed", "deployed", groupModel, "#fff6d8", null);
        this.addToModelsIfNotExists(models, "closed", "closed", groupModel, "#def7ff", null);
        this.addToModelsIfNotExists(models, "done", "done", groupModel, "#ccfaf1", Integer.valueOf(4));
        this.addToModelsIfNotExists(models, "postponed", "postponed", groupModel, "#fde5ea", null);
        this.addToModelsIfNotExists(models, "on_discussion", "on_duscussion", groupModel, "#d4f2f6", Integer.valueOf(7));
    }

    private void createHRIssueStatus(List<IssueStatusModel> models, GroupModel groupModel) {
        this.addToModelsIfNotExists(models, "initiated", "initiated", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "signed", "signed", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "cancelled", "cancelled", groupModel, "#ffe9f2", null);
        this.addToModelsIfNotExists(models, "account_termination_process", "account_termination_process", groupModel, "ebe9fe", null);
        this.addToModelsIfNotExists(models, "transferred_to_accounting", "transferred_to_accounting", groupModel, "#f3e3fc", null);
        this.addToModelsIfNotExists(models, "accounting_termination_transaction", "accounting_termination_transaction", groupModel, "#def7ff", null);
        this.addToModelsIfNotExists(models, "application_form_received", "application_form_received", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "application_form_review", "application_form_review", groupModel, "#ffede8", null);
        this.addToModelsIfNotExists(models, "rejected", "rejected", groupModel, "#d4f2f6", null);
        this.addToModelsIfNotExists(models, "hr_interview", "hr_interview", groupModel, "ebe9fe", null);
        this.addToModelsIfNotExists(models, "technical_interview", "technical_interview", groupModel, "#f3e3fc", null);
        this.addToModelsIfNotExists(models, "group_interview", "group_interview", groupModel, "#fce0fb", null);
        this.addToModelsIfNotExists(models, "contract_creation", "contract_creation", groupModel, "#ffe9f2", null);
        this.addToModelsIfNotExists(models, "contract_signing", "contract_signing", groupModel, "#fff6d8", null);
        this.addToModelsIfNotExists(models, "starting_employment", "starting_employment", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "closed", "closed", groupModel, "#def7ff", null);
    }

    private void createDocumentFlowStatus(List<IssueStatusModel> models, GroupModel groupModel) {
        this.addToModelsIfNotExists(models, "initiated", "initiated", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "under_review", "under_review", groupModel, "ebe9fe", null);
        this.addToModelsIfNotExists(models, "under_revision", "under_revision", groupModel, "#f3e3fc", null);
        this.addToModelsIfNotExists(models, "under_approval", "under_approval", groupModel, "#fce0fb", null);
        this.addToModelsIfNotExists(models, "in_signing", "in_signing", groupModel, "#fff6d8", null);
        this.addToModelsIfNotExists(models, "signed", "signed", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "cancelled", "cancelled", groupModel, "#ffe9f2", null);
        this.addToModelsIfNotExists(models, "for_information", "for_information", groupModel, "#d4f2f6", null);
        this.addToModelsIfNotExists(models, "archived", "archived", groupModel, "#def7ff", null);
        this.addToModelsIfNotExists(models, "received", "received", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "under_control", "under_control", groupModel, "#d1f5d1", null);
        this.addToModelsIfNotExists(models, "in_progress", "in_progress", groupModel, "#ffede8", null);
        this.addToModelsIfNotExists(models, "no_action_required", "no_action_required", groupModel, "#fde5e5", null);
        this.addToModelsIfNotExists(models, "response_approved", "response_approved", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "created", "created", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "done", "done", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "reopened", "reopened", groupModel, "#ffe9f2", null);
    }

    private void createSupportFlowStatus(List<IssueStatusModel> models, GroupModel groupModel) {
        this.addToModelsIfNotExists(models, "received", "received", groupModel, "#cfe2fd", null);
        this.addToModelsIfNotExists(models, "under_control", "under_control", groupModel, "#d1f5d1", null);
        this.addToModelsIfNotExists(models, "archived", "archived", groupModel, "#def7ff", null);
        this.addToModelsIfNotExists(models, "in_progress", "in_progress", groupModel, "#ffede8", null);
        this.addToModelsIfNotExists(models, "no_action_required", "no_action_required", groupModel, "#fde5e5", null);
        this.addToModelsIfNotExists(models, "response_approved", "response_approved", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "awaiting_response", "awaiting_response", groupModel, "#ccfaf1", null);
        this.addToModelsIfNotExists(models, "sent_back", "sent_back", groupModel, "#ffe9f2", null);
        this.addToModelsIfNotExists(models, "closed", "closed", groupModel, "#def7ff", null);
    }

    private void addToModelsIfNotExists(List<IssueStatusModel> models, String name, String description, GroupModel groupModel, String color, Integer maxDaysHeals) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createIssueStatusModel(name, description, groupModel, color, maxDaysHeals));
        }
    }

    private IssueStatusModel createIssueStatusModel(String name, String description, GroupModel groupModel, String color, Integer maxDaysHeals) {
        IssueStatusModel model = new IssueStatusModel();
        model.setName(this.getNameTranslation(name));
        model.setIcon(SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)("img/status." + name + ".png")));
        model.setDescription(this.getDescriptionTranslation(description));
        model.setGroup(groupModel);
        model.setColor(color);
        model.setStatusHealth(maxDaysHeals);
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("issuestatus.name." + key, this.getLanguage().getCode());
    }

    private String getDescriptionTranslation(String key) {
        return this.getContext().getMessageTranslation("issuestatus.description." + key, this.getLanguage().getCode());
    }
}

