/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.bean.populate.SOURCES;
import systems.dennis.flaw.model.IssueTypeModel;
import systems.dennis.shared.config.WebContext;

public class IssueTypePopulate
extends AbstractPopulateDispatcher<IssueTypeModel> {
    public void populate() {
        List models = this.createIssueTypeModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<IssueTypeModel> createIssueTypeModels() {
        ArrayList<IssueTypeModel> models = new ArrayList<IssueTypeModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        if (groupType.equalsIgnoreCase("Development")) {
            this.createDevelopmentIssueTypes(models);
        }
        if (groupType.equalsIgnoreCase("HR")) {
            this.createHRIssueTypes(models);
        }
        if (groupType.equalsIgnoreCase("Document Flow")) {
            this.createDocumentFlowTypes(models);
        }
        if (groupType.equalsIgnoreCase("Support")) {
            this.createSupportFlowTypes(models);
        }
        return models;
    }

    private void createDevelopmentIssueTypes(List<IssueTypeModel> models) {
        this.addToModelsIfNotExists(models, "bug", "Please enter text");
        this.addToModelsIfNotExists(models, "change_request", "Please enter text");
        this.addToModelsIfNotExists(models, "revert", "Please enter text");
        this.addToModelsIfNotExists(models, "task", "Please enter text");
        this.addToModelsIfNotExists(models, "question", "Please enter text");
    }

    private void createHRIssueTypes(List<IssueTypeModel> models) {
        this.addToModelsIfNotExists(models, "employee_termination", "Please enter text");
        this.addToModelsIfNotExists(models, "hiring", "Please enter text");
    }

    private void createDocumentFlowTypes(List<IssueTypeModel> models) {
        this.addToModelsIfNotExists(models, "order", "Please enter text");
        this.addToModelsIfNotExists(models, "assignment", "Please enter text");
        this.addToModelsIfNotExists(models, "incoming_letter", "Please enter text");
        this.addToModelsIfNotExists(models, "outgoing_letter", "Please enter text");
    }

    private void createSupportFlowTypes(List<IssueTypeModel> models) {
        this.addToModelsIfNotExists(models, "request", "Please enter text");
    }

    private void addToModelsIfNotExists(List<IssueTypeModel> models, String name, String issueTemplate) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createIssueTypeModel(name, issueTemplate));
        }
    }

    private IssueTypeModel createIssueTypeModel(String name, String issueTemplate) {
        IssueTypeModel model = new IssueTypeModel();
        model.setName(this.getNameTranslation(name));
        model.setIssueTypeTemplate(issueTemplate);
        model.setGroup(this.getGroup());
        model.setIcon(SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)("/img/type." + name + ".png")));
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("issuetype.name." + key, this.getLanguage().getCode());
    }
}

