/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.bean.populate.SOURCES;
import systems.dennis.flaw.model.PriorityModel;
import systems.dennis.shared.config.WebContext;

public class PriorityPopulate
extends AbstractPopulateDispatcher<PriorityModel> {
    public void populate() {
        List models = this.createModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<PriorityModel> createModels() {
        ArrayList<PriorityModel> priorities = new ArrayList<PriorityModel>();
        String groupName = this.getGroupType().getName();
        if (groupName.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        if (groupName.equalsIgnoreCase("HR")) {
            this.createHrPriorityModels(priorities);
        } else {
            this.createStandardPriorityModels(priorities);
        }
        return priorities;
    }

    private void createStandardPriorityModels(List<PriorityModel> priorities) {
        this.addToModelsIfNotExists(priorities, "low", Integer.valueOf(0), SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)"img/prio.low.svg"));
        this.addToModelsIfNotExists(priorities, "medium", Integer.valueOf(50), SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)"img/prio.medium.svg"));
        this.addToModelsIfNotExists(priorities, "high", Integer.valueOf(100), SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)"/img/prio.high.svg"));
    }

    private void createHrPriorityModels(List<PriorityModel> priorities) {
        this.addToModelsIfNotExists(priorities, "low", Integer.valueOf(0), SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)"img/prio.low.svg"));
        this.addToModelsIfNotExists(priorities, "high", Integer.valueOf(100), SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)"/img/prio.high.svg"));
    }

    private void addToModelsIfNotExists(List<PriorityModel> models, String name, Integer priority, String url) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createModel(name, priority, url));
        }
    }

    private PriorityModel createModel(String name, Integer priority, String url) {
        PriorityModel model = new PriorityModel();
        model.setGroup(this.getGroup());
        model.setName(this.getNameTranslation(name));
        model.setPrioNumber(priority);
        model.setIcon(url);
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("prio.name." + key, this.getLanguage().getCode());
    }
}

