/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.ProjectFlowModel;
import systems.dennis.flaw.model.ProjectTypeModel;
import systems.dennis.flaw.repo.ProjectFlowRepo;
import systems.dennis.flaw.repo.ProjectTypeRepo;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;

public class ProjectFlowPopulate
extends AbstractPopulateDispatcher<ProjectFlowModel> {
    private static final String PROJECT_FLOW_NAME_KEY = "projectflow.name.";
    private static final String PROJECT_TYPE_NAME_KEY = "projecttype.name.";
    private static final String PROJECT_FLOW_CREATED = "created";
    private static final String PROJECT_FLOW_ANALYSIS = "analysis";
    private static final String PROJECT_FLOW_PLANNING = "planning";
    private static final String PROJECT_FLOW_ENGINEERING_AND_DESIGN = "engineering_and_design";
    private static final String PROJECT_FLOW_DEVELOPMENT = "development";
    private static final String PROJECT_FLOW_TESTING = "testing";
    private static final String PROJECT_FLOW_DEPLOYMENT = "deployment";
    private static final String PROJECT_FLOW_SUPPORT = "support";
    private static final String PROJECT_FLOW_CLOSED = "closed";

    public void populate() {
        ProjectFlowRepo repo = (ProjectFlowRepo)this.getContext().getBean(ProjectFlowRepo.class);
        List models = this.createProjectFlowModels();
        if (!models.isEmpty()) {
            repo.saveAll((Iterable)models);
        }
    }

    private List<ProjectFlowModel> createProjectFlowModels() {
        ArrayList<ProjectFlowModel> models = new ArrayList<ProjectFlowModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, PROJECT_FLOW_CREATED, this.findProjectTypeByName(PROJECT_FLOW_DEVELOPMENT));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_ANALYSIS, this.findProjectTypeByName(PROJECT_FLOW_ENGINEERING_AND_DESIGN));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_PLANNING, this.findProjectTypeByName(PROJECT_FLOW_ENGINEERING_AND_DESIGN));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_ENGINEERING_AND_DESIGN, this.findProjectTypeByName(PROJECT_FLOW_ENGINEERING_AND_DESIGN));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_DEVELOPMENT, this.findProjectTypeByName(PROJECT_FLOW_DEVELOPMENT));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_TESTING, this.findProjectTypeByName(PROJECT_FLOW_DEVELOPMENT));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_DEPLOYMENT, this.findProjectTypeByName(PROJECT_FLOW_DEVELOPMENT));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_SUPPORT, this.findProjectTypeByName("audit"));
        this.addToModelsIfNotExists(models, PROJECT_FLOW_CLOSED, this.findProjectTypeByName(PROJECT_FLOW_DEVELOPMENT));
        return models;
    }

    private void addToModelsIfNotExists(List<ProjectFlowModel> models, String name, ProjectTypeModel projectTypeModel) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createProjectFlowModel(name, projectTypeModel));
        }
    }

    private ProjectFlowModel createProjectFlowModel(String stageName, ProjectTypeModel projectTypeModel) {
        ProjectFlowModel model = new ProjectFlowModel();
        model.setName(this.getNameTranslation(stageName));
        model.setProjectType(projectTypeModel);
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private ProjectTypeModel findProjectTypeByName(String name) {
        ProjectTypeRepo repo = (ProjectTypeRepo)this.getContext().getBean(ProjectTypeRepo.class);
        return (ProjectTypeModel)repo.findOne((Specification)QueryCase.equalsOf((String)"name", (Object)this.getTypeTranslation(name)).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()))).orElseThrow(() -> new ItemNotFoundException(name));
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation(PROJECT_FLOW_NAME_KEY + key, this.getLanguage().getCode());
    }

    private String getTypeTranslation(String key) {
        return this.getContext().getMessageTranslation(PROJECT_TYPE_NAME_KEY + key, this.getLanguage().getCode());
    }
}

