/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.bean.populate.SOURCES;
import systems.dennis.flaw.model.ProjectTypeModel;
import systems.dennis.shared.config.WebContext;

public class ProjectTypePopulate
extends AbstractPopulateDispatcher<ProjectTypeModel> {
    private static final String ICON_PATH_PREFIX = "img/type.";
    private static final String ICON_PATH_SUFFIX = ".png";
    private static final String PROJECT_TYPE_NAME_KEY = "projecttype.name.";
    public static final String PROJECT_TYPE_DEVELOPMENT = "development";
    public static final String PROJECT_TYPE_ENGINEERING_AND_DESIGN = "engineering_and_design";
    public static final String PROJECT_TYPE_AUDIT = "audit";

    public void populate() {
        List models = this.createProjectTypeModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<ProjectTypeModel> createProjectTypeModels() {
        ArrayList<ProjectTypeModel> models = new ArrayList<ProjectTypeModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, PROJECT_TYPE_DEVELOPMENT, "Please enter text");
        this.addToModelsIfNotExists(models, PROJECT_TYPE_ENGINEERING_AND_DESIGN, "Please enter text");
        this.addToModelsIfNotExists(models, PROJECT_TYPE_AUDIT, "Please enter text");
        return models;
    }

    private void addToModelsIfNotExists(List<ProjectTypeModel> models, String name, String projectTemplate) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createProjectTypeModel(name, projectTemplate));
        }
    }

    private ProjectTypeModel createProjectTypeModel(String name, String projectTemplate) {
        ProjectTypeModel model = new ProjectTypeModel();
        model.setName(this.getNameTranslation(name));
        model.setProjectTypeTemplate(projectTemplate);
        model.setGroup(this.getGroup());
        model.setIcon(SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)(ICON_PATH_PREFIX + name + ICON_PATH_SUFFIX)));
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation(PROJECT_TYPE_NAME_KEY + key, this.getLanguage().getCode());
    }
}

