/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.SolutionTypeModel;

public class SolutionTypePopulate
extends AbstractPopulateDispatcher<SolutionTypeModel> {
    public void populate() {
        List models = this.createSolutionTypeModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<SolutionTypeModel> createSolutionTypeModels() {
        ArrayList<SolutionTypeModel> models = new ArrayList<SolutionTypeModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, "resolved", "resolved");
        this.addToModelsIfNotExists(models, "not_resolved", "not_resolved");
        return models;
    }

    private void addToModelsIfNotExists(List<SolutionTypeModel> models, String name, String description) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createSolutionTypeModel(name, description));
        }
    }

    private SolutionTypeModel createSolutionTypeModel(String name, String description) {
        SolutionTypeModel model = new SolutionTypeModel();
        model.setName(this.getNameTranslation(name));
        model.setDescription(this.getDescriptionTranslation(description));
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("solutiontype.name." + key, this.getLanguage().getCode());
    }

    private String getDescriptionTranslation(String key) {
        return this.getContext().getMessageTranslation("solutiontype.description." + key, this.getLanguage().getCode());
    }
}

