/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.repo.SprintFlowRepo;

public class SprintFlowPopulate
extends AbstractPopulateDispatcher<SprintFlowModel> {
    public void populate() {
        SprintFlowRepo repo = (SprintFlowRepo)this.getContext().getBean(SprintFlowRepo.class);
        List models = this.createSprintFlowModels();
        if (!models.isEmpty()) {
            repo.saveAll((Iterable)models);
        }
    }

    public boolean shouldPopulate() {
        SprintFlowRepo repo = (SprintFlowRepo)this.getContext().getBean(SprintFlowRepo.class);
        return repo.count() == 0L;
    }

    private List<SprintFlowModel> createSprintFlowModels() {
        ArrayList<SprintFlowModel> models = new ArrayList<SprintFlowModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, "quick");
        this.addToModelsIfNotExists(models, "usual");
        return models;
    }

    private void addToModelsIfNotExists(List<SprintFlowModel> models, String name) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createSprintFlowModel(name));
        }
    }

    private SprintFlowModel createSprintFlowModel(String name) {
        SprintFlowModel model = new SprintFlowModel();
        model.setName(this.getNameTranslation(name));
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("sprintflow.name." + key, this.getLanguage().getCode());
    }
}

