/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.model.SprintFlowStageModel;
import systems.dennis.flaw.model.SprintStatusModel;
import systems.dennis.flaw.repo.SprintFlowRepo;
import systems.dennis.flaw.repo.SprintFlowStageRepo;
import systems.dennis.flaw.repo.SprintStatusRepo;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;

public class SprintFlowStagePopulate
extends AbstractPopulateDispatcher<SprintFlowStageModel> {
    public void populate() {
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return;
        }
        SprintFlowStageRepo sprintFlowStageRepo = (SprintFlowStageRepo)this.getContext().getBean(SprintFlowStageRepo.class);
        List quickSprintFlowStageModels = this.createQuickSprintFlowStageModels();
        this.addFlowStageToFlow("quick", quickSprintFlowStageModels);
        List usualSprintFlowStageModels = this.createUsualSprintFlowStageModels();
        this.addFlowStageToFlow("usual", usualSprintFlowStageModels);
    }

    private List<SprintFlowStageModel> createUsualSprintFlowStageModels() {
        ArrayList<SprintFlowStageModel> models = new ArrayList<SprintFlowStageModel>();
        models.add(this.createSprintFlowStageModel(null, "created", "in_progress"));
        models.add(this.createSprintFlowStageModel("created", "in_progress", "done"));
        models.add(this.createSprintFlowStageModel("in_progress", "done", "to_test"));
        models.add(this.createSprintFlowStageModel("done", "to_test", "on_testing"));
        models.add(this.createSprintFlowStageModel("reopened", "on_testing", "tested"));
        models.add(this.createSprintFlowStageModel("created", "reopened", "in_progress"));
        models.add(this.createSprintFlowStageModel("reopened", "tested", "deployed"));
        models.add(this.createSprintFlowStageModel("on_testing", "deployed", "closed"));
        models.add(this.createSprintFlowStageModel("deployed", "closed", null));
        return models;
    }

    private List<SprintFlowStageModel> createQuickSprintFlowStageModels() {
        ArrayList<SprintFlowStageModel> models = new ArrayList<SprintFlowStageModel>();
        models.add(this.createSprintFlowStageModel(null, "created", "in_progress"));
        models.add(this.createSprintFlowStageModel("created", "in_progress", "done"));
        models.add(this.createSprintFlowStageModel("reopened", "done", null));
        models.add(this.createSprintFlowStageModel("created", "reopened", "in_progress"));
        return models;
    }

    private void addFlowStageToFlow(String name, List<SprintFlowStageModel> sprintFlowStageModels) {
        SprintFlowRepo sprintFlowRepo = (SprintFlowRepo)this.getContext().getBean(SprintFlowRepo.class);
        SprintFlowModel sprintFlowModel = this.findBySprintFlowName(name);
        if (Objects.isNull(sprintFlowModel.getStages()) || sprintFlowModel.getStages().isEmpty()) {
            sprintFlowModel.setStages(sprintFlowStageModels);
            sprintFlowRepo.save((Object)sprintFlowModel);
        }
    }

    private SprintFlowStageModel createSprintFlowStageModel(String prev, String current, String next) {
        SprintFlowStageModel model = new SprintFlowStageModel();
        model.setPrevStatus(this.findBySprintStatusName(prev));
        model.setCurrentStatus(this.findBySprintStatusName(current));
        model.setNexStatus(this.findBySprintStatusName(next));
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private SprintStatusModel findBySprintStatusName(String name) {
        if (Objects.isNull(name)) {
            return null;
        }
        String status = this.getSprintStatusTranslation(name);
        SprintStatusRepo repo = (SprintStatusRepo)this.getContext().getBean(SprintStatusRepo.class);
        return (SprintStatusModel)repo.findOne((Specification)QueryCase.equalsOf((String)"name", (Object)status).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()))).orElseThrow(() -> new ItemNotFoundException(name));
    }

    private SprintFlowModel findBySprintFlowName(String name) {
        String sprintFlow = this.getSprintFlowTranslation(name);
        SprintFlowRepo sprintFlowRepo = (SprintFlowRepo)this.getContext().getBean(SprintFlowRepo.class);
        return (SprintFlowModel)sprintFlowRepo.findOne((Specification)QueryCase.equalsOf((String)"name", (Object)sprintFlow).specification().addCase(QueryCase.equalsOf((String)"group", (Object)this.getGroup())).addCase(QueryCase.equalsOf((String)"demo", (Object)true)).addCase(QueryCase.equalsOf((String)"demoData", (Object)this.getDemoData()))).orElseThrow(() -> new ItemNotFoundException(name));
    }

    private String getSprintStatusTranslation(String key) {
        return this.getContext().getMessageTranslation("sprintstatus.name." + key, this.getLanguage().getCode());
    }

    private String getSprintFlowTranslation(String key) {
        return this.getContext().getMessageTranslation("sprintflow.name." + key, this.getLanguage().getCode());
    }
}

