/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.SprintStatusModel;

public class SprintStatusPopulate
extends AbstractPopulateDispatcher<SprintStatusModel> {
    public void populate() {
        List models = this.createSprintStatusModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<SprintStatusModel> createSprintStatusModels() {
        ArrayList<SprintStatusModel> models = new ArrayList<SprintStatusModel>();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, "created", "created");
        this.addToModelsIfNotExists(models, "on_testing", "on_testing");
        this.addToModelsIfNotExists(models, "reopened", "reopened");
        this.addToModelsIfNotExists(models, "in_progress", "in_progress");
        this.addToModelsIfNotExists(models, "in_test", "in_test");
        this.addToModelsIfNotExists(models, "tested", "tested");
        this.addToModelsIfNotExists(models, "to_test", "to_test");
        this.addToModelsIfNotExists(models, "deployed", "deployed");
        this.addToModelsIfNotExists(models, "closed", "closed");
        this.addToModelsIfNotExists(models, "done", "done");
        return models;
    }

    private void addToModelsIfNotExists(List<SprintStatusModel> models, String name, String description) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createSprintStatusModel(name, description));
        }
    }

    private SprintStatusModel createSprintStatusModel(String name, String description) {
        SprintStatusModel model = new SprintStatusModel();
        model.setName(this.getNameTranslation(name));
        model.setDescription(this.getDescriptionTranslation(description));
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("sprintstatus.name." + key, this.getLanguage().getCode());
    }

    private String getDescriptionTranslation(String key) {
        return this.getContext().getMessageTranslation("sprintstatus.description." + key, this.getLanguage().getCode());
    }
}

