/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.bean.populate.SOURCES;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.StoryStatusModel;
import systems.dennis.shared.config.WebContext;

public class StoryStatusPopulate
extends AbstractPopulateDispatcher<StoryStatusModel> {
    private static final String ICON_PATH_PREFIX = "img/status.";
    private static final String ICON_PATH_SUFFIX = ".png";
    private static final String STORY_STATUS_NAME_KEY = "storystatus.name.";
    private static final String STORY_STATUS_PENDING = "pending";
    private static final String STORY_STATUS_TODO = "to_do";
    private static final String STORY_STATUS_DISCUSSING = "discussing";
    private static final String STORY_STATUS_DEVELOPING = "developing";
    private static final String STORY_STATUS_CONFIRMING = "confirming";
    private static final String STORY_STATUS_FINISHED = "finished";

    public void populate() {
        List models = this.createStoryStatusModels();
        if (!models.isEmpty()) {
            this.getRepository().saveAll((Iterable)models);
        }
    }

    private List<StoryStatusModel> createStoryStatusModels() {
        ArrayList<StoryStatusModel> models = new ArrayList<StoryStatusModel>();
        GroupModel groupModel = this.getGroup();
        String groupType = this.getGroupType().getName();
        if (groupType.equalsIgnoreCase("Empty")) {
            return Collections.emptyList();
        }
        this.addToModelsIfNotExists(models, STORY_STATUS_PENDING, groupModel);
        this.addToModelsIfNotExists(models, STORY_STATUS_TODO, groupModel);
        this.addToModelsIfNotExists(models, STORY_STATUS_DISCUSSING, groupModel);
        this.addToModelsIfNotExists(models, STORY_STATUS_DEVELOPING, groupModel);
        this.addToModelsIfNotExists(models, STORY_STATUS_CONFIRMING, groupModel);
        this.addToModelsIfNotExists(models, STORY_STATUS_FINISHED, groupModel);
        return models;
    }

    private void addToModelsIfNotExists(List<StoryStatusModel> models, String name, GroupModel groupModel) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createStoryStatusModel(name, groupModel));
        }
    }

    private StoryStatusModel createStoryStatusModel(String statusName, GroupModel groupModel) {
        StoryStatusModel model = new StoryStatusModel();
        model.setName(this.getNameTranslation(statusName));
        model.setIcon(SOURCES.getPath((WebContext.LocalWebContext)this.getContext(), (String)(ICON_PATH_PREFIX + statusName + ICON_PATH_SUFFIX)));
        model.setGroup(groupModel);
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String statusName) {
        return this.getContext().getMessageTranslation(STORY_STATUS_NAME_KEY + statusName, this.getLanguage().getCode());
    }
}

