/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.bean.populate;

import java.util.ArrayList;
import java.util.List;
import systems.dennis.flaw.bean.populate.AbstractPopulateDispatcher;
import systems.dennis.flaw.model.WorkTypeModel;

public class WorkTypePopulate
extends AbstractPopulateDispatcher<WorkTypeModel> {
    public void populate() {
        List models = this.createWorkTypeModels();
        this.getRepository().saveAll((Iterable)models);
    }

    private List<WorkTypeModel> createWorkTypeModels() {
        ArrayList<WorkTypeModel> models = new ArrayList<WorkTypeModel>();
        this.addToModelsIfNotExists(models, "working_day");
        this.addToModelsIfNotExists(models, "day_off");
        this.addToModelsIfNotExists(models, "shortened");
        this.addToModelsIfNotExists(models, "holiday");
        return models;
    }

    private void addToModelsIfNotExists(List<WorkTypeModel> models, String name) {
        if (!this.isDemoExist(this.getNameTranslation(name))) {
            models.add(this.createWorkTypeModel(name));
        }
    }

    private WorkTypeModel createWorkTypeModel(String name) {
        WorkTypeModel model = new WorkTypeModel();
        model.setName(this.getNameTranslation(name));
        model.setGroup(this.getGroup());
        model.setDemo(Boolean.valueOf(true));
        model.setDemoData(this.getDemoData());
        return model;
    }

    private String getNameTranslation(String key) {
        return this.getContext().getMessageTranslation("worktype.name." + key, this.getLanguage().getCode());
    }
}

