/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.controller.GroupableController;
import systems.dennis.flaw.controller.IssueStatusController;
import systems.dennis.flaw.controller.issue.IssueController;
import systems.dennis.flaw.form.BoardForm;
import systems.dennis.flaw.form.IssueStatusForm;
import systems.dennis.flaw.model.BoardModel;
import systems.dennis.flaw.model.IssueBoardStatusForm;
import systems.dennis.flaw.model.IssueBoardStatusModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.service.BoardService;
import systems.dennis.flaw.service.EpicStatusService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.GetByIdItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/flaw/board"})
@WebFormsSupport(value=BoardService.class)
@CrossOrigin
public class BoardController
extends ApplicationContext
implements AddItemController<BoardModel, BoardForm>,
EditItemController<BoardModel, BoardForm>,
GroupableController,
GetByIdItemController<BoardModel, BoardForm>,
ListItemController<BoardModel, BoardForm>,
DeleteItemController {
    @GetMapping(value={"/all"}, produces={"application/json"})
    public Page<Map<String, Object>> find() {
        return this.toFormPage(this.getService().search(new MagicRequest()));
    }

    @GetMapping(value={"/data/{id}/status/{status_id}"}, produces={"application/json"})
    public Page<Map<String, Object>> getBoardData(@PathVariable(value="id") Long id, @PathVariable(value="status_id") Long statusId, @RequestParam(value="page") Integer page) {
        if (page == null) {
            page = 0;
        }
        return ((IssueController)this.getBean(IssueController.class)).toFormPage(((IssueService)this.getContext().getBean(IssueService.class)).findByBoard(id, statusId, page.intValue()));
    }

    public BoardForm toForm(BoardModel model) {
        BoardForm form = (BoardForm)((BeanCopier)this.getBean(BeanCopier.class)).copy((Object)model, BoardForm.class);
        IssueStatusController issueBean = (IssueStatusController)this.getBean(IssueStatusController.class);
        ArrayList<IssueBoardStatusForm> statusList = new ArrayList<IssueBoardStatusForm>();
        for (IssueBoardStatusModel status : model.getStatuses()) {
            IssueBoardStatusForm statusForm = new IssueBoardStatusForm();
            statusForm.setOrder(status.getOrder());
            statusForm.setModel((IssueStatusForm)issueBean.toForm((BaseEntity)status.getModel()));
            statusForm.setId(status.getId());
            statusList.add(statusForm);
        }
        statusList.sort(Comparator.comparing(IssueBoardStatusForm::getOrder));
        form.setStatuses(statusList);
        return form;
    }

    public BoardModel fromForm(BoardForm form) {
        BoardModel model = (BoardModel)((BeanCopier)this.getBean(BeanCopier.class)).copy((Object)form, BoardModel.class);
        IssueStatusController issueBean = (IssueStatusController)this.getBean(IssueStatusController.class);
        ArrayList<IssueBoardStatusModel> statusList = new ArrayList<IssueBoardStatusModel>();
        for (IssueBoardStatusForm status : form.getStatuses()) {
            IssueBoardStatusModel statusForm = new IssueBoardStatusModel();
            statusForm.setOrder(status.getOrder());
            statusForm.setModel((IssueStatusModel)issueBean.fromForm((DefaultForm)status.getModel()));
            statusForm.setId(status.getId());
            statusList.add(statusForm);
        }
        statusList.sort(Comparator.comparing(IssueBoardStatusModel::getOrder));
        model.setStatuses(statusList);
        return model;
    }

    public BoardService getService() {
        return (BoardService)super.getService();
    }

    public BoardController(WebContext context) {
        super(context);
    }

    static {
        SearchEntityApi.registerSearch((String)"board", (SearcherInfo)new SearcherInfo("name", EpicStatusService.class));
    }
}

