/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.response.CalculationResult;
import systems.dennis.flaw.service.CalculateSalaryService;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/calculate/salary"})
@CrossOrigin
public class CalculateSalaryController
extends ApplicationContext {
    private final CalculateSalaryService calculateSalaryService;

    public CalculateSalaryController(WebContext context, CalculateSalaryService calculateSalaryService) {
        super(context);
        this.calculateSalaryService = calculateSalaryService;
    }

    @GetMapping(value={"/year/{year}/month/{month}"})
    @WithRole
    public CalculationResult calculateSalary(@PathVariable Integer year, @PathVariable Integer month) {
        return this.calculateSalaryService.calculateSalary(year, month);
    }
}

