/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.CommentForm;
import systems.dennis.flaw.model.CommentModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.comment.CommentService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/comment"})
@WebFormsSupport(value=CommentService.class)
@CrossOrigin
public class CommentController
extends ApplicationContext
implements AddItemController<CommentModel, CommentForm>,
EditItemController<CommentModel, CommentForm>,
DeleteItemController {
    public CommentController(WebContext context) {
        super(context);
    }

    @WithRole
    @GetMapping(value={"/issue/{id}"})
    public Page<Map<String, Object>> findByIssue(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page, @PathVariable(value="id") Long issueId) {
        IssueModel issue = (IssueModel)((IssueService)this.getBean(IssueService.class)).findByIdOrThrow(issueId);
        MagicRequest request = new MagicRequest();
        request.getCases().add(QueryCase.equalsOf((String)"issue", (Object)issue));
        Page comments = this.getService().search(request);
        comments.getContent().forEach(x -> {
            Long userId = x.getHr().getRemoteId();
            x.setUserId(userId);
        });
        return this.toFormPage(comments);
    }

    @WithRole
    @GetMapping(value={"/my_tagged"})
    public Page<Map<String, Object>> getMyTaggedComments(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        HRModel me = ((HRService)this.getContext().getBean(HRService.class)).me();
        String tag = "@" + me.getId();
        DefaultSearchSpecification specification = QueryCase.containsInSensitive((String)"text", (Object)tag).specification();
        Page comments = this.getService().find(specification, from, limit, page);
        return this.toFormPage(comments);
    }

    public CommentService getService() {
        return (CommentService)this.getBean(CommentService.class);
    }
}

