/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.flaw.exception.ExternalServiceException;
import systems.dennis.flaw.form.GitConfigForm;
import systems.dennis.flaw.form.GitConfigProjectForm;
import systems.dennis.flaw.model.GitConfigProjectModel;
import systems.dennis.flaw.service.GitConfigProjectService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/plugins/version_control/git_lab/project"})
@WebFormsSupport(value=GitConfigProjectService.class)
@CrossOrigin
public class GitLabConfigProjectController
extends ApplicationContext
implements Transformable<GitConfigProjectModel, GitConfigProjectForm>,
DeleteItemController {
    public GitLabConfigProjectController(WebContext context) {
        super(context);
    }

    @WithRole
    @PostMapping(value={"/add/{projectId}"})
    public ResponseEntity<GitConfigProjectForm> add(@RequestBody GitConfigForm gitConfigForm, @PathVariable Long projectId) {
        String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + currentToken);
        headers.set("AUTH_SCOPE", this.getScopeId());
        String addPath = this.getVersionControlPath() + "/git_lab/config/add";
        try {
            HttpEntity requestEntity = new HttpEntity((Object)gitConfigForm, (MultiValueMap)headers);
            GitConfigForm gitConfig = (GitConfigForm)new RestTemplate().exchange(addPath, HttpMethod.POST, requestEntity, GitConfigForm.class, new Object[0]).getBody();
            GitConfigProjectModel model = this.getService().generateAndSave(projectId, gitConfig.getUid());
            GitConfigProjectForm resul = (GitConfigProjectForm)this.toForm((BaseEntity)model);
            resul.setGitConfig(gitConfig);
            return ResponseEntity.ok((Object)resul);
        }
        catch (Exception e) {
            throw new ExternalServiceException((Serializable)e, "global.exception.external_service_error");
        }
    }

    @WithRole
    @PostMapping(value={"/link/{projectId}/{uuid}"})
    public ResponseEntity<GitConfigProjectForm> add(@PathVariable Long projectId, @PathVariable(value="uuid") String uuidConfig) {
        String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
        GitConfigProjectModel model = this.getService().generateAndSave(projectId, uuidConfig);
        GitConfigProjectForm resul = (GitConfigProjectForm)this.toForm((BaseEntity)model);
        GitConfigForm form = new GitConfigForm();
        form.setUid(uuidConfig);
        resul.setGitConfig(form);
        return ResponseEntity.ok((Object)resul);
    }

    @WithRole
    @GetMapping(value={"/{projectId}"})
    public List<GitConfigProjectForm> getByProject(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page, @PathVariable Long projectId) {
        List models = this.getService().getByProject(projectId, from, limit, page);
        return models.stream().map(x -> {
            GitConfigProjectForm el = (GitConfigProjectForm)this.toForm((BaseEntity)x);
            el.setGitConfig(this.getGitConfig(x.getGitConfigUid()));
            return el;
        }).collect(Collectors.toList());
    }

    private GitConfigForm getGitConfig(String uid) {
        String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + currentToken);
        headers.set("AUTH_SCOPE", this.getScopeId());
        String addPath = this.getVersionControlPath() + "/git_lab/config/" + uid;
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            return (GitConfigForm)new RestTemplate().exchange(addPath, HttpMethod.GET, requestEntity, GitConfigForm.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new ExternalServiceException((Serializable)e, "global.exception.external_service_error");
        }
    }

    public GitConfigProjectService getService() {
        return (GitConfigProjectService)this.getBean(GitConfigProjectService.class);
    }

    private String getVersionControlPath() {
        return (String)this.getContext().getEnv("servers.version_control.request.path");
    }

    private String getScopeId() {
        return this.getContext().getEnv("dennis.systems.security.scope.id").toString();
    }
}

