/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.flaw.controller.GitLabImporterController;
import systems.dennis.flaw.controller.ProjectController;
import systems.dennis.flaw.controller.issue.IssueController;
import systems.dennis.flaw.exception.ExternalServiceException;
import systems.dennis.flaw.form.ImportIssueForm;
import systems.dennis.flaw.form.ImportProjectForm;
import systems.dennis.flaw.form.IssueForm;
import systems.dennis.flaw.form.ProjectForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.IssueFlowService;
import systems.dennis.flaw.service.IssueFlowStageService;
import systems.dennis.flaw.service.IssueStatusService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/plugins/version_control/git_lab/importer"})
@CrossOrigin
public class GitLabImporterController
extends ApplicationContext {
    private static final String AUTH_SCOPE_HEADER = "AUTH_SCOPE";

    public GitLabImporterController(WebContext context) {
        super(context);
    }

    @PostMapping(value={"/project/{groupId}/{gitUid}"})
    @WithRole
    public List<ProjectForm> importProjects(@PathVariable(value="gitUid") String gitUid, @PathVariable(value="groupId") Long groupId) {
        GroupModel group = (GroupModel)((GroupService)this.getBean(GroupService.class)).findByIdOrThrow(groupId);
        String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + currentToken);
        headers.set(AUTH_SCOPE_HEADER, this.getScopeId());
        String addPath = this.getVersionControlPath() + "/git_lab/importer/project/" + gitUid;
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            1 responseType = new /* Unavailable Anonymous Inner Class!! */;
            List projects = (List)new RestTemplate().exchange(addPath, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)responseType, new Object[0]).getBody();
            ArrayList<ProjectForm> result = new ArrayList<ProjectForm>();
            if (projects != null) {
                ProjectController projectController = (ProjectController)this.getBean(ProjectController.class);
                for (ImportProjectForm importForm : projects) {
                    ProjectForm form = (ProjectForm)projectController.toForm((BaseEntity)this.generateAndSaveProject(importForm, group));
                    result.add(form);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ExternalServiceException((Serializable)e, "global.exception.external_service_error");
        }
    }

    @PostMapping(value={"/issue/{projectId}/{gitUid}"})
    @WithRole
    public List<IssueForm> importIssue(@PathVariable(value="projectId") Long projectId, @PathVariable(value="gitUid") String gitUid) {
        ProjectModel project = (ProjectModel)((ProjectService)this.getBean(ProjectService.class)).findByIdOrThrow(projectId);
        String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + currentToken);
        headers.set(AUTH_SCOPE_HEADER, this.getScopeId());
        String addPath = this.getVersionControlPath() + "/git_lab/importer/issue/" + gitUid;
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            2 responseType = new /* Unavailable Anonymous Inner Class!! */;
            List issues = (List)new RestTemplate().exchange(addPath, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)responseType, new Object[0]).getBody();
            ArrayList<IssueForm> result = new ArrayList<IssueForm>();
            if (issues != null) {
                IssueController issueController = (IssueController)this.getBean(IssueController.class);
                for (ImportIssueForm importForm : issues) {
                    IssueForm form = (IssueForm)issueController.toForm((BaseEntity)this.generateAndSaveIssue(importForm, project));
                    result.add(form);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ExternalServiceException((Serializable)e, "global.exception.external_service_error");
        }
    }

    private String getVersionControlPath() {
        return (String)this.getContext().getEnv("servers.version_control.request.path");
    }

    private String getScopeId() {
        return this.getContext().getEnv("dennis.systems.security.scope.id").toString();
    }

    private ProjectModel generateAndSaveProject(ImportProjectForm form, GroupModel group) {
        ProjectModel model = new ProjectModel();
        model.setName(form.getName());
        model.setDescription(form.getDescription());
        model.setCreated(form.getCreated());
        model.setImportDate(new Date());
        model.setImportType(form.getImportType());
        model.setGroup(group);
        model = (ProjectModel)((ProjectService)this.getBean(ProjectService.class)).save((BaseEntity)model);
        List issues = form.getIssues();
        for (ImportIssueForm issueForm : issues) {
            this.generateAndSaveIssue(issueForm, model);
        }
        return model;
    }

    private IssueModel generateAndSaveIssue(ImportIssueForm form, ProjectModel project) {
        IssueStatusModel status = this.setIssueStatus(project.getGroup(), form.getIssueState());
        IssueFlowModel issueFlow = project.getGroup().getDefaultIssueFlow();
        IssueModel model = new IssueModel();
        model.setName(form.getName());
        model.setDescription(form.getDescription());
        model.setCreated(form.getCreated());
        model.setImportDate(new Date());
        model.setImportType(form.getImportType());
        model.setProject(project);
        model.setGroup(project.getGroup());
        model.setIssueFlow(issueFlow);
        model.setStatus(status);
        return (IssueModel)((IssueService)this.getBean(IssueService.class)).save((BaseEntity)model);
    }

    private IssueStatusModel setIssueStatus(GroupModel group, String statusName) {
        IssueFlowModel issueFlow = group.getDefaultIssueFlow();
        if (issueFlow != null) {
            List stages = issueFlow.getStages();
            Optional<IssueStatusModel> existingStatus = stages.stream().map(IssueFlowStageModel::getCurrentStatus).filter(s -> s.getName().equalsIgnoreCase(statusName)).findFirst();
            return existingStatus.orElseGet(() -> {
                IssueStatusModel newStatus = this.createNewStatus(statusName, group);
                this.createAndSaveStage(newStatus, issueFlow);
                return newStatus;
            });
        }
        return this.createNewStatus(statusName, group);
    }

    private IssueStatusModel createNewStatus(String statusName, GroupModel group) {
        Optional existingStatus = ((IssueStatusService)this.getBean(IssueStatusService.class)).getByNameAndGroup(statusName, group);
        if (existingStatus.isPresent()) {
            return (IssueStatusModel)existingStatus.get();
        }
        IssueStatusModel status = new IssueStatusModel();
        status.setName(statusName);
        status.setGroup(group);
        if (statusName.equalsIgnoreCase("closed")) {
            status.setIsClosed(Boolean.valueOf(true));
        }
        return (IssueStatusModel)((IssueStatusService)this.getBean(IssueStatusService.class)).save((BaseEntity)status);
    }

    private void createAndSaveStage(IssueStatusModel status, IssueFlowModel issueFlow) {
        List stages = issueFlow.getStages();
        IssueFlowStageModel issueFlowStage = new IssueFlowStageModel();
        issueFlowStage.setCurrentStatus(status);
        ((IssueFlowStageService)this.getBean(IssueFlowStageService.class)).save((BaseEntity)issueFlowStage);
        stages.add(issueFlowStage);
        issueFlow.setStages(stages);
        ((IssueFlowService)this.getBean(IssueFlowService.class)).save((BaseEntity)issueFlow);
    }
}

