/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.bean.populate.PopulateDispatcher;
import systems.dennis.flaw.controller.IssueFlowController;
import systems.dennis.flaw.form.GroupForm;
import systems.dennis.flaw.form.IssueFlowForm;
import systems.dennis.flaw.form.WorkLogSummaryForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupTypeModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.GroupTypeService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.GetByIdItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.LanguageModel;
import systems.dennis.shared.service.LanguageService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/flaw/group"})
@WebFormsSupport(value=GroupService.class)
@CrossOrigin
@Secured
public class GroupController
extends ApplicationContext
implements AddItemController<GroupModel, GroupForm>,
EditItemController<GroupModel, GroupForm>,
ListItemController<GroupModel, GroupForm>,
GetByIdItemController<GroupModel, GroupForm>,
DeleteItemController {
    @WithRole
    @GetMapping(value={"/my"}, produces={"application/json"})
    public Page<Map<String, Object>> getMyGroups() {
        return this.toFormPage(this.getService().search(new MagicRequest()));
    }

    @WithRole
    @GetMapping(value={"/flaw/{id}"}, produces={"application/json"})
    public Map<String, Object> getIssueFlow(@PathVariable Long id) {
        GroupModel group = (GroupModel)this.getService().findById(id).orElseThrow(() -> new ItemNotFoundException(id));
        if (Objects.isNull(group.getDefaultIssueFlow())) {
            return new HashMap<String, Object>();
        }
        IssueFlowForm flowForm = ((IssueFlowController)this.getContext().getBean(IssueFlowController.class)).toForm(group.getDefaultIssueFlow());
        return BeanCopier.values((DefaultForm)flowForm, (BaseEntity)group.getDefaultIssueFlow(), (WebContext.LocalWebContext)this.getContext());
    }

    @WithRole
    @GetMapping(value={"/workLog_summary/{id}"})
    public List<WorkLogSummaryForm> getWorkLog(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page, @PathVariable Long id) {
        return this.getService().getWorkLog(id, from, limit, page);
    }

    @WithRole
    @PostMapping(value={"/demo/upload/{groupId}/{languageId}/{groupTypeId}"})
    public void uploadDemo(@PathVariable Long groupId, @PathVariable Long languageId, @PathVariable Long groupTypeId) {
        GroupModel group = (GroupModel)this.getService().findByIdOrThrow(groupId);
        LanguageModel language = (LanguageModel)((LanguageService)this.getBean(LanguageService.class)).findByIdOrThrow(languageId);
        GroupTypeModel groupType = (GroupTypeModel)((GroupTypeService)this.getBean(GroupTypeService.class)).findByIdOrThrow(groupTypeId);
        List populateDispatchers = this.getService().initializePopulateDispatchers(this.getContext(), group, language, groupType);
        List deleteDispatchers = this.getService().initializeDeleteDispatchers(this.getContext(), group, language, groupType);
        for (PopulateDispatcher deleteDispatcher : deleteDispatchers) {
            deleteDispatcher.deleteDemo();
        }
        for (PopulateDispatcher populateDispatcher : populateDispatchers) {
            populateDispatcher.populate();
        }
    }

    public GroupService getService() {
        return (GroupService)super.getService();
    }

    public GroupController(WebContext context) {
        super(context);
    }

    static {
        SearchEntityApi.registerSearch((String)"group", (SearcherInfo)new SearcherInfo("name", GroupService.class));
    }
}

