/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.GroupTypeForm;
import systems.dennis.flaw.model.GroupTypeModel;
import systems.dennis.flaw.service.GroupTypeService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/group_type"})
@WebFormsSupport(value=GroupTypeService.class)
@CrossOrigin
public class GroupTypeController
extends ApplicationContext
implements AddItemController<GroupTypeModel, GroupTypeForm>,
EditItemController<GroupTypeModel, GroupTypeForm>,
ListItemController<GroupTypeModel, GroupTypeForm>,
DeleteItemController {
    public GroupTypeController(WebContext context) {
        super(context);
    }

    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<GroupTypeForm> add(GroupTypeForm form) throws ItemForAddContainsIdException {
        return super.add((DefaultForm)form);
    }

    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<GroupTypeForm> edit(GroupTypeForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return super.edit((DefaultForm)form);
    }

    @WithRole(value="ROLE_ADMIN")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        super.delete(id);
    }

    static {
        SearchEntityApi.registerSearch((String)"group_type", (SearcherInfo)new SearcherInfo("name", GroupTypeService.class));
    }
}

