/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.flaw.exception.InvitationException;
import systems.dennis.flaw.form.HRForm;
import systems.dennis.flaw.form.InvitationForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/hr"})
@WebFormsSupport(value=HRService.class)
@CrossOrigin
public class HRController
extends ApplicationContext
implements AddItemController<HRModel, HRForm>,
EditItemController<HRModel, HRForm>,
ListItemController<HRModel, HRForm>,
DeleteItemController {
    public static final String SERVERS_AUTH_REQUEST_PATH = "servers.auth.request.path";

    public HRController(WebContext context) {
        super(context);
    }

    @WithRole
    @GetMapping(value={"/invited"})
    public Page<Map<String, Object>> getMyInvitedHr(@RequestParam(value="from", required=false, defaultValue="0") Long from, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit, @RequestParam(value="page", required=false, defaultValue="0") Integer page) {
        try {
            String path = String.valueOf(this.getContext().getEnv(SERVERS_AUTH_REQUEST_PATH)) + "/invitation/my_accepted?from=" + from + "&limit=" + limit + "&page=" + page;
            String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + currentToken);
            InvitationForm[] invitations = (InvitationForm[])new RestTemplate().exchange(path, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), InvitationForm[].class, new Object[0]).getBody();
            if (invitations == null) {
                return Page.empty();
            }
            Page myInvitedHr = this.getService().getMyInvitedHr(Arrays.asList(invitations));
            return this.toFormPage(myInvitedHr);
        }
        catch (Exception e) {
            throw new InvitationException((Serializable)e, "global.exception.failed_process_invitation");
        }
    }

    public HRService getService() {
        return (HRService)this.getBean(HRService.class);
    }

    static {
        SearchEntityApi.registerSearch((String)"hr", (SearcherInfo)new SearcherInfo("name", HRService.class));
    }
}

