/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.controller.GroupableController;
import systems.dennis.flaw.controller.IssueFlowStageController;
import systems.dennis.flaw.form.IssueFlowForm;
import systems.dennis.flaw.form.IssueFlowStageForm;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.service.IssueFlowService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/flaw/issue_flow"})
@WebFormsSupport(value=IssueFlowService.class)
@CrossOrigin
public class IssueFlowController
extends ApplicationContext
implements AddItemController<IssueFlowModel, IssueFlowForm>,
EditItemController<IssueFlowModel, IssueFlowForm>,
GroupableController,
ListItemController<IssueFlowModel, IssueFlowForm>,
DeleteItemController {
    public IssueFlowController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/board/create/{id}"})
    public Boolean createBoard(@PathVariable Long id) {
        IssueFlowModel flow = (IssueFlowModel)this.getService().findByIdOrThrow(id);
        this.getService().afterAdd(flow);
        return true;
    }

    @PutMapping(value={"/update_stages/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public List<IssueFlowStageForm> changeFlowStages(@PathVariable Long id, @RequestBody List<IssueFlowStageForm> stages) {
        ArrayList models = new ArrayList();
        stages.forEach(x -> models.add(((IssueFlowStageController)this.getBean(IssueFlowStageController.class)).fromForm(x)));
        return this.getService().updateStages(id, models).stream().map(x -> ((IssueFlowStageController)this.getBean(IssueFlowStageController.class)).toForm(x)).collect(Collectors.toList());
    }

    public IssueFlowService getService() {
        return (IssueFlowService)super.getService();
    }

    public IssueFlowForm toForm(IssueFlowModel model) {
        IssueFlowForm form = (IssueFlowForm)((BeanCopier)this.getBean(BeanCopier.class)).copy((Object)model, IssueFlowForm.class);
        if (Objects.nonNull(model.getStages())) {
            IssueFlowStageController flowStageController = (IssueFlowStageController)this.getBean(IssueFlowStageController.class);
            ArrayList<IssueFlowStageForm> flowStages = new ArrayList<IssueFlowStageForm>();
            for (IssueFlowStageModel flowStage : model.getStages()) {
                flowStages.add(flowStageController.toForm(flowStage));
            }
            form.setStages(flowStages);
        }
        return form;
    }

    public IssueFlowModel fromForm(IssueFlowForm form) {
        IssueFlowModel model = (IssueFlowModel)((BeanCopier)this.getBean(BeanCopier.class)).copy((Object)form, IssueFlowModel.class);
        if (Objects.nonNull(form.getStages())) {
            IssueFlowStageController flowStageController = (IssueFlowStageController)this.getBean(IssueFlowStageController.class);
            ArrayList<IssueFlowStageModel> flowStages = new ArrayList<IssueFlowStageModel>();
            for (IssueFlowStageForm flowStage : form.getStages()) {
                flowStages.add(flowStageController.fromForm(flowStage));
            }
            model.setStages(flowStages);
        }
        return model;
    }

    static {
        SearchEntityApi.registerSearch((String)"issue_flow", (SearcherInfo)new SearcherInfo("name", IssueFlowService.class));
    }
}

