/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.IssueFlowHistoryForm;
import systems.dennis.flaw.model.IssueFlowHistoryModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.IssueFlowHistoryService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/issue_flow_history"})
@WebFormsSupport(value=IssueFlowHistoryService.class)
@CrossOrigin
public class IssueFlowHistoryController
extends ApplicationContext
implements ListItemController<IssueFlowHistoryModel, IssueFlowHistoryForm> {
    private static final Logger log = LoggerFactory.getLogger(IssueFlowHistoryController.class);
    @Autowired
    private HttpServletRequest httpServletRequest;

    public IssueFlowHistoryController(WebContext context) {
        super(context);
    }

    public Page<Map<String, Object>> fetchData(MagicRequest request) {
        String id = this.httpServletRequest.getParameter("id");
        if (this.httpServletRequest.getParameter("id") != null) {
            try {
                IssueModel issue = (IssueModel)((IssueService)this.getBean(IssueService.class)).findById(Long.valueOf(id)).orElseThrow(() -> new ItemNotFoundException("issue_with_id_not_found"));
                request.getCases().add(QueryCase.equalsOf((String)"issue", (Object)issue));
            }
            catch (Exception e) {
                log.error("Cannot get Id or Issue not found " + id);
            }
        }
        return super.fetchData(request);
    }
}

