/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.IssueHistoryForm;
import systems.dennis.flaw.model.IssueHistoryModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.IssueHistoryService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/issue_history"})
@WebFormsSupport(value=IssueHistoryService.class)
@CrossOrigin
public class IssueHistoryController
extends ApplicationContext
implements Transformable<IssueHistoryModel, IssueHistoryForm> {
    public IssueHistoryController(WebContext context) {
        super(context);
    }

    @WithRole
    @GetMapping(value={"/issue/{id}"})
    public Page<Map<String, Object>> getByIssue(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page, @PathVariable(value="id") Long issueId) {
        Specification specification = ((IssueHistoryService)this.getBean(IssueHistoryService.class)).getAdditionalSpecification();
        IssueModel issue = (IssueModel)((IssueService)this.getBean(IssueService.class)).findByIdOrThrow(issueId);
        Page histories = ((IssueHistoryService)this.getBean(IssueHistoryService.class)).find(specification.and((Specification)QueryCase.equalsOf((String)"issue", (Object)issue).specification()), from, limit, page);
        return this.toFormPage(histories);
    }

    @GetMapping(value={"/list"})
    @WithRole(value="ROLE_ADMIN")
    public Page<Map<String, Object>> get(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        Page histories = ((IssueHistoryService)this.getBean(IssueHistoryService.class)).find(from, limit, page);
        return this.toFormPage(histories);
    }
}

