/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.IssueToIssueLinkForm;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueToIssueLinkModel;
import systems.dennis.flaw.service.IssueToIssueLinkService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/flaw/issue_to_issue_link"})
@WebFormsSupport(value=IssueToIssueLinkService.class)
@CrossOrigin
public class IssueToIssueLinkController
extends ApplicationContext
implements AddItemController<IssueToIssueLinkModel, IssueToIssueLinkForm>,
EditItemController<IssueToIssueLinkModel, IssueToIssueLinkForm>,
ListItemController<IssueToIssueLinkModel, IssueToIssueLinkForm>,
DeleteItemController {
    public IssueToIssueLinkController(WebContext context) {
        super(context);
    }

    @GetMapping(produces={"application/json"}, value={"/by_parent/{id}"})
    @WithRole
    public List<Map<String, Object>> byIssue(@PathVariable(value="id") Long issueId) {
        IssueModel parent = (IssueModel)((IssueService)this.getBean(IssueService.class)).findById(issueId).orElseThrow(() -> new ItemNotFoundException(issueId));
        DefaultSearchSpecification spec = QueryCase.equalsOf((String)"parent", (Object)parent).specification();
        List res = this.getService().find(spec, Long.valueOf(0L), null, null).getContent();
        return res.stream().map(x -> {
            IssueToIssueLinkForm itemTranslated = (IssueToIssueLinkForm)((BeanCopier)this.getBean(BeanCopier.class)).copy(x, IssueToIssueLinkForm.class);
            return BeanCopier.values((DefaultForm)itemTranslated, (BaseEntity)x, (WebContext.LocalWebContext)this.getContext());
        }).collect(Collectors.toList());
    }

    public IssueToIssueLinkService getService() {
        return (IssueToIssueLinkService)this.getBean(IssueToIssueLinkService.class);
    }
}

