/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.SalaryForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SalaryModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.SalaryService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/salary"})
@WebFormsSupport(value=SalaryService.class)
@CrossOrigin
public class SalaryController
extends ApplicationContext
implements AddItemController<SalaryModel, SalaryForm>,
EditItemController<SalaryModel, SalaryForm>,
ListItemController<SalaryModel, SalaryForm>,
DeleteItemController {
    public SalaryController(WebContext context) {
        super(context);
    }

    public SalaryService getService() {
        return (SalaryService)this.getBean(SalaryService.class);
    }

    @GetMapping(value={"/latest/{hr}"})
    public SalaryModel findByHR(@PathVariable Long hr) {
        return this.getService().findUsersCurrentSalary((HRModel)((HRService)this.getBean(HRService.class)).findByIdOrThrow(hr));
    }
}

