/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.controller.GroupableController;
import systems.dennis.flaw.controller.WorkFlowController;
import systems.dennis.flaw.form.SprintForm;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.model.view.SprintProgressView;
import systems.dennis.flaw.repo.SprintProgressViewRepo;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.flaw.service.sprint.SprintService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.GeneratedPojoList;

@RestController
@RequestMapping(value={"/api/v2/flaw/sprint"})
@WebFormsSupport(value=SprintService.class)
@CrossOrigin
public class SprintController
extends ApplicationContext
implements AddItemController<SprintModel, SprintForm>,
EditItemController<SprintModel, SprintForm>,
ItemCounter,
ListItemController<SprintModel, SprintForm>,
GroupableController,
DeleteItemController,
WorkFlowController<SprintModel, SprintForm, SprintFlowModel> {
    @WithRole
    @GetMapping(value={"/progress/{id}"}, produces={"application/json"})
    public SprintProgressView getProgress(@PathVariable(value="id") Long id) {
        return (SprintProgressView)((SprintProgressViewRepo)this.getContext().getBean(SprintProgressViewRepo.class)).findBySprintId(id).orElseThrow(() -> new ItemNotFoundException(id));
    }

    @WithRole
    @GetMapping(value={"/issues/{id}"}, produces={"application/json"})
    public List<Map<String, Object>> getSprintIssues(@PathVariable(value="id") Long id) {
        return ((IssueService)this.getContext().getBean(IssueService.class)).findBySprintId(id);
    }

    public SprintController(WebContext context) {
        super(context);
    }

    public GeneratedPojoList fetchForm() {
        return super.fetchForm();
    }

    public SprintFlowModel getFlow(SprintModel model) {
        return model.getSprintFlow();
    }

    static {
        SearchEntityApi.registerSearch((String)"sprint", (SearcherInfo)new SearcherInfo("description", SprintService.class));
    }
}

