/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.TestResultForm;
import systems.dennis.flaw.model.TestResultModel;
import systems.dennis.flaw.service.TestResultService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/test_result"})
@WebFormsSupport(value=TestResultService.class)
@CrossOrigin
public class TestResultController
extends ApplicationContext
implements AddItemController<TestResultModel, TestResultForm>,
EditItemController<TestResultModel, TestResultForm>,
ListItemController<TestResultModel, TestResultForm>,
DeleteItemController {
    public TestResultController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/{checklistId}"})
    public Page<TestResultForm> findByChecklist(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page, @PathVariable(value="checklistId") Long checklistId) {
        TestResultService testResultService = (TestResultService)this.getService();
        DefaultSearchSpecification specification = testResultService.findByChecklist(checklistId);
        Page testResults = testResultService.find(specification, from, limit, page);
        return testResults.map(arg_0 -> ((TestResultController)this).toForm(arg_0));
    }
}

