/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.UserNotificationForm;
import systems.dennis.flaw.model.UserNotificationModel;
import systems.dennis.flaw.service.UserNotificationService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.MagicOrder;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@Secured
@RequestMapping(value={"/api/v2/flaw/user_notification"})
@WebFormsSupport(value=UserNotificationService.class)
public class UserNotificationController
extends ApplicationContext
implements Transformable<UserNotificationModel, UserNotificationForm>,
DeleteItemController {
    public UserNotificationController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/my"})
    @WithRole
    public Page<UserNotificationForm> getUnreadNotification(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        UserNotificationService userNotificationService = (UserNotificationService)this.getService();
        List specification = userNotificationService.getUnreadNotifications();
        if (limit == null) {
            limit = 25;
        }
        if (page == null) {
            page = 0;
        }
        MagicRequest request = new MagicRequest();
        request.setCases(specification);
        request.setSort(Collections.singletonList(MagicOrder.ID_DESC));
        request.setPage(page);
        request.setLimit(limit);
        Page issueModels = userNotificationService.search(request);
        return issueModels.map(arg_0 -> ((UserNotificationController)this).toForm(arg_0));
    }

    @PostMapping(value={"/{notificationId}/read"})
    public void changeNotificationReadStatus(@PathVariable Long notificationId, @RequestParam(value="isRead") boolean isRead) {
        UserNotificationService userNotificationService = (UserNotificationService)this.getService();
        userNotificationService.changeNotificationReadStatus(notificationId, isRead);
    }
}

