/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.exception.IssueFlowException;
import systems.dennis.flaw.exception.WorkFlowException;
import systems.dennis.flaw.form.WorkFlowFormHolder;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.service.AbstractService;

@RestController
@Secured
public interface WorkFlowController<DB_TYPE extends BaseEntity, FORM extends DefaultForm, FLOW_MODEL extends BaseEntity>
extends Serviceable,
Transformable<DB_TYPE, FORM> {
    @PostMapping(value={"/promote/{id}"})
    @WithRole
    default public WorkFlowFormHolder promote(@PathVariable Long id) {
        try {
            AbstractService service = this.getService();
            BaseEntity model = (BaseEntity)service.findByIdClone(id).orElseThrow(() -> new ItemNotFoundException(id));
            BaseEntity currentStage = this.getStageFromFlow(id);
            Method getNexStatus = currentStage.getClass().getMethod("getNexStatus", new Class[0]);
            Object nextStatus = getNexStatus.invoke((Object)currentStage, new Object[0]);
            if (nextStatus == null) {
                throw new WorkFlowException(id, "flow_is_finished");
            }
            Method setStatus = model.getClass().getMethod("setStatus", nextStatus.getClass());
            setStatus.invoke((Object)model, nextStatus);
            BaseEntity modelAfterPromote = service.save(model);
            return this.createFormHolder(modelAfterPromote);
        }
        catch (Exception e) {
            throw new WorkFlowException((Serializable)((Object)e.getMessage()));
        }
    }

    @PostMapping(value={"/demote/{id}"})
    @WithRole
    default public WorkFlowFormHolder demote(@PathVariable Long id) {
        try {
            AbstractService service = this.getService();
            BaseEntity model = (BaseEntity)service.findByIdClone(id).orElseThrow(() -> new ItemNotFoundException(id));
            BaseEntity currentStage = this.getStageFromFlow(id);
            Method getPrevStatus = currentStage.getClass().getMethod("getPrevStatus", new Class[0]);
            Object prevStatus = getPrevStatus.invoke((Object)currentStage, new Object[0]);
            if (prevStatus == null) {
                throw new WorkFlowException(id, "flow_is_finished");
            }
            Method setStatus = model.getClass().getMethod("setStatus", prevStatus.getClass());
            setStatus.invoke((Object)model, prevStatus);
            BaseEntity modelAfterPromote = service.save(model);
            return this.createFormHolder(modelAfterPromote);
        }
        catch (Exception e) {
            throw new WorkFlowException((Serializable)((Object)e.getMessage()));
        }
    }

    @WithRole
    @GetMapping(value={"/adjacent_status/{id}"}, produces={"application/json"})
    default public WorkFlowFormHolder checkAdjacentStatus(@PathVariable Long id) {
        AbstractService service = this.getService();
        try {
            BaseEntity model = (BaseEntity)service.findByIdClone(id).orElseThrow(() -> new ItemNotFoundException(id));
            return this.createFormHolder(model);
        }
        catch (Exception e) {
            WorkFlowFormHolder formHolder = new WorkFlowFormHolder();
            formHolder.setHasForward(Boolean.valueOf(false));
            formHolder.setHasBack(Boolean.valueOf(false));
            return formHolder;
        }
    }

    default public WorkFlowFormHolder createFormHolder(DB_TYPE model) {
        boolean hasForwardStatus = false;
        boolean hasBackStatus = false;
        try {
            BaseEntity flowStage = this.getStageFromFlow(model.getId());
            Method getNexStatus = flowStage.getClass().getMethod("getNexStatus", new Class[0]);
            hasForwardStatus = getNexStatus.invoke((Object)flowStage, new Object[0]) != null;
            Method getPrevStatus = flowStage.getClass().getMethod("getPrevStatus", new Class[0]);
            hasBackStatus = getPrevStatus.invoke((Object)flowStage, new Object[0]) != null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        WorkFlowFormHolder formHolder = new WorkFlowFormHolder();
        formHolder.setValue(this.toForm(model));
        formHolder.setHasForward(Boolean.valueOf(hasForwardStatus));
        formHolder.setHasBack(Boolean.valueOf(hasBackStatus));
        return formHolder;
    }

    default public BaseEntity getStageFromFlow(Long id) {
        AbstractService service = this.getService();
        BaseEntity model = (BaseEntity)service.findByIdClone(id).orElseThrow(() -> new ItemNotFoundException(id));
        BaseEntity flow = this.getFlow(model);
        if (flow == null) {
            throw new WorkFlowException(id, "no_flow_is_selected");
        }
        Method getStatus = model.getClass().getMethod("getStatus", new Class[0]);
        Object status = getStatus.invoke((Object)model, new Object[0]);
        if (status == null) {
            throw new IssueFlowException(id, "status_is_undefined");
        }
        Method getStages = flow.getClass().getMethod("getStages", new Class[0]);
        List stages = (List)getStages.invoke((Object)flow, new Object[0]);
        if (stages == null || stages.isEmpty()) {
            throw new IssueFlowException(id, "stages_are_not_created");
        }
        BaseEntity currentStage = null;
        for (Object stage : stages) {
            Method getCurrentStatus = stage.getClass().getMethod("getCurrentStatus", new Class[0]);
            BaseEntity statusFromStage = (BaseEntity)getCurrentStatus.invoke(stage, new Object[0]);
            if (!statusFromStage.equals(status)) continue;
            currentStage = (BaseEntity)stage;
            break;
        }
        if (currentStage == null) {
            throw new IssueFlowException(id, "flow_is_not_consist_stage_with_status_" + String.valueOf(status));
        }
        return currentStage;
    }

    public FLOW_MODEL getFlow(DB_TYPE var1);
}

