/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.WorkLogForm;
import systems.dennis.flaw.form.WorkLogSummaryForm;
import systems.dennis.flaw.model.WorkLogModel;
import systems.dennis.flaw.repo.UserWorkLogReportRepo;
import systems.dennis.flaw.service.WorkLogService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListSelfItemsController;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/work_log"})
@WebFormsSupport(value=WorkLogService.class)
@CrossOrigin
@Secured
public class WorkLogController
extends ApplicationContext
implements AddItemController<WorkLogModel, WorkLogForm>,
EditItemController<WorkLogModel, WorkLogForm>,
ListSelfItemsController<WorkLogModel, WorkLogForm>,
DeleteItemController {
    public WorkLogController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/summary/year/{year}/month/{month}"})
    public List<WorkLogSummaryForm> findByPeriod(@PathVariable(value="year") Integer year, @PathVariable(value="month") Integer month) {
        DefaultSearchSpecification spec = QueryCase.equalsOf((String)"month", (Object)month).specification();
        spec.addCase(QueryCase.equalsOf((String)"year", (Object)year));
        return ((UserWorkLogReportRepo)this.getBean(UserWorkLogReportRepo.class)).findAll((Specification)spec);
    }

    public WorkLogService getService() {
        return (WorkLogService)this.getBean(WorkLogService.class);
    }

    static {
        SearchEntityApi.registerSearch((String)"work_log", (SearcherInfo)new SearcherInfo("name", WorkLogService.class));
    }
}

