/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.WorkingCalendarForm;
import systems.dennis.flaw.model.WorkingCalendarModel;
import systems.dennis.flaw.service.WorkingCalendarService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/flaw/work_calendar"})
@WebFormsSupport(value=WorkingCalendarService.class)
@CrossOrigin
public class WorkingCalendarController
extends ApplicationContext
implements AddItemController<WorkingCalendarModel, WorkingCalendarForm>,
EditItemController<WorkingCalendarModel, WorkingCalendarForm>,
ListItemController<WorkingCalendarModel, WorkingCalendarForm>,
DeleteItemController {
    private final BeanCopier copier;

    public WorkingCalendarController(WebContext context, BeanCopier copier) {
        super(context);
        this.copier = copier;
    }

    @WithRole(value="ROLE_WC")
    public ResponseEntity<WorkingCalendarForm> add(WorkingCalendarForm model) throws ItemForAddContainsIdException {
        return super.add((DefaultForm)model);
    }

    @WithRole(value="ROLE_WC")
    public ResponseEntity<WorkingCalendarForm> edit(WorkingCalendarForm object) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return super.edit((DefaultForm)object);
    }

    @WithRole(value="ROLE_WC")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        super.delete(id);
    }

    public WorkingCalendarService getService() {
        return (WorkingCalendarService)this.getContext().getBean(WorkingCalendarService.class);
    }

    @GetMapping(value={"/year/{year}/month/{month}"})
    public WorkingCalendarForm findByYearAndMonth(@PathVariable Integer year, @PathVariable Integer month) {
        return (WorkingCalendarForm)this.copier.copy((Object)this.getService().findByYearAndMonth(year, month), WorkingCalendarForm.class);
    }

    public String getDefaultField() {
        return "name";
    }

    static {
        SearchEntityApi.registerSearch((String)"wc", (SearcherInfo)new SearcherInfo("name", WorkingCalendarService.class));
    }
}

