/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller.issue;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.annotation.OpenGroupCondition;
import systems.dennis.flaw.controller.CloseIssueRequestObject;
import systems.dennis.flaw.controller.EpicController;
import systems.dennis.flaw.controller.GroupController;
import systems.dennis.flaw.controller.GroupableController;
import systems.dennis.flaw.controller.ProjectController;
import systems.dennis.flaw.controller.SprintController;
import systems.dennis.flaw.controller.StoryController;
import systems.dennis.flaw.controller.issue.SimilarIssueRequest;
import systems.dennis.flaw.form.IssueForm;
import systems.dennis.flaw.form.IssueFormHolder;
import systems.dennis.flaw.model.CommentModel;
import systems.dennis.flaw.model.EpicModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.StoryModel;
import systems.dennis.flaw.repo.IssueRepo;
import systems.dennis.flaw.response.IssuePathResponse;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.IssueStatusService;
import systems.dennis.flaw.service.MyService;
import systems.dennis.flaw.service.comment.CommentService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.controller.items.magic.MagicQuery;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/flaw/issue"})
@WebFormsSupport(value=IssueService.class)
@CrossOrigin
public class IssueController
extends ApplicationContext
implements AddItemController<IssueModel, IssueForm>,
EditItemController<IssueModel, IssueForm>,
GroupableController,
ListItemController<IssueModel, IssueForm>,
DeleteItemController {
    private MyService service;

    public IssueController(MyService service, WebContext context) {
        super(context);
        this.service = service;
    }

    @PostMapping(value={"/similar"})
    @WithRole
    public Page<Map<String, Object>> searchSimilar(@RequestBody SimilarIssueRequest request) {
        IssueService issueService = this.getService();
        return this.toFormPage(issueService.findSimilar(request));
    }

    @PostMapping(value={"/promote/{issueId}"})
    @WithRole
    public IssueFormHolder promote(@PathVariable Long issueId) {
        IssueService issueService = this.getService();
        return issueService.promote(issueId);
    }

    @GetMapping(value={"/path/{issueId}"}, produces={"application/json"})
    @WithRole
    public IssuePathResponse getPath(@PathVariable(value="issueId") Long id) {
        IssueModel issueModel = (IssueModel)this.getService().findById(id).orElseThrow(() -> new ItemNotFoundException(id));
        IssuePathResponse response = new IssuePathResponse();
        response.addPath(((GroupController)this.getBean(GroupController.class)).toForm((BaseEntity)issueModel.getGroup()));
        if (issueModel.getProject() != null) {
            response.addPath(((ProjectController)this.getBean(ProjectController.class)).toForm((BaseEntity)issueModel.getProject()));
        }
        if (issueModel.getSprint() != null) {
            response.addPath(((SprintController)this.getBean(SprintController.class)).toForm((BaseEntity)issueModel.getSprint()));
        }
        if (issueModel.getEpic() != null) {
            response.addPath(((EpicController)this.getBean(EpicController.class)).toForm((BaseEntity)issueModel.getEpic()));
        }
        if (issueModel.getStory() != null) {
            response.addPath(((StoryController)this.getBean(StoryController.class)).toForm((BaseEntity)issueModel.getStory()));
        }
        if (issueModel.getParent() != null) {
            response.addPath(this.toForm((BaseEntity)issueModel.getParent()));
        }
        return response;
    }

    @GetMapping(value={"/path/{id}/{type}"}, produces={"application/json"})
    @WithRole
    public IssuePathResponse getPath(@PathVariable(value="id") Long id, @PathVariable(value="type") String type) {
        Object epic;
        Object story;
        Object project;
        Object group;
        Class searchBean = SearchEntityApi.findServiceByType((String)type);
        BaseEntity model = ((AbstractService)this.getContext().getBean(searchBean)).findByIdOrThrow(id);
        IssuePathResponse response = new IssuePathResponse();
        if (this.isFieldPresent("group", model.getClass()).booleanValue() && Objects.nonNull(group = BeanCopier.readValue((Object)model, (String)"group"))) {
            response.addPath(((GroupController)this.getBean(GroupController.class)).toForm((BaseEntity)((GroupModel)group)));
        }
        if (this.isFieldPresent("project", model.getClass()).booleanValue() && Objects.nonNull(project = BeanCopier.readValue((Object)model, (String)"project"))) {
            response.addPath(((ProjectController)this.getBean(ProjectController.class)).toForm((BaseEntity)((ProjectModel)project)));
        }
        if (this.isFieldPresent("story", model.getClass()).booleanValue() && Objects.nonNull(story = BeanCopier.readValue((Object)model, (String)"story"))) {
            response.addPath(((StoryController)this.getBean(StoryController.class)).toForm((BaseEntity)((StoryModel)story)));
        }
        if (this.isFieldPresent("epic", model.getClass()).booleanValue() && Objects.nonNull(epic = BeanCopier.readValue((Object)model, (String)"epic"))) {
            response.addPath(((EpicController)this.getBean(EpicController.class)).toForm((BaseEntity)((EpicModel)epic)));
        }
        return response;
    }

    private Boolean isFieldPresent(String name, Class<?> c) {
        try {
            BeanCopier.findField((String)name, c);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @PostMapping(value={"/close", "/close/"}, produces={"application/json"}, consumes={"application/json"})
    public IssueForm closeIssue(@RequestBody CloseIssueRequestObject object) {
        IssueModel issue = (IssueModel)this.getService().findByIdOrThrow(object.getId());
        issue.setFinishedOn(new Date());
        issue.setForceUpdate(true);
        if (object.getStatus() != null) {
            IssueStatusModel status = (IssueStatusModel)((IssueStatusService)this.getContext().getBean(IssueStatusService.class)).findByIdOrThrow(object.getStatus());
            issue.setStatus(status);
        }
        if (object.getRemovePerformer() != null && object.getRemovePerformer().booleanValue()) {
            issue.setPerformer(null);
        }
        IssueModel res = (IssueModel)this.getService().save((BaseEntity)issue);
        issue.setFinishedOn(new Date());
        this.getService().getRepository().save((Object)issue);
        if (object.getComment() != null && !object.getComment().isEmpty()) {
            CommentModel comment = new CommentModel();
            comment.setIssue(issue);
            comment.setText(object.getComment());
            comment.setHr(((HRService)this.getContext().getBean(HRService.class)).me());
            ((CommentService)this.getBean(CommentService.class)).save((BaseEntity)comment);
        }
        return (IssueForm)this.toForm((BaseEntity)res);
    }

    public IssueService getService() {
        return (IssueService)super.getService();
    }

    @WithRole
    @PostMapping(value={"/demote/{issueId}"})
    public IssueFormHolder demote(@PathVariable Long issueId) {
        IssueService issueService = this.getService();
        return issueService.demote(issueId);
    }

    @WithRole
    @GetMapping(value={"/adjacent_status/{issueId}"}, produces={"application/json"})
    public IssueFormHolder checkAdjacentStatus(@PathVariable Long issueId) {
        IssueService issueService = this.getService();
        return issueService.checkAdjacentStatus(issueId);
    }

    @WithRole
    @PostMapping(value={"/created"}, produces={"application/json"})
    public Page<Map<String, Object>> myIssues(@RequestBody MagicRequest request) {
        return this.toFormPage(this.service.getCreatedByMeIssues(request));
    }

    @WithRole
    @PostMapping(value={"/assigned"}, produces={"application/json"})
    public Page<Map<String, Object>> myAssignIssues(@RequestBody MagicRequest request) {
        return this.toFormPage(this.service.getAssignedToMeIssues(request));
    }

    @PostMapping(value={"/testing"}, produces={"application/json"})
    @WithRole
    public Page<Map<String, Object>> myTestingIssues(@RequestBody MagicRequest request) {
        return this.toFormPage(this.service.getTestingByMeIssues(request));
    }

    @PostMapping(value={"/new"}, produces={"application/json"})
    @WithRole
    public Page<Map<String, Object>> newElements(@RequestBody MagicRequest request) {
        return this.toFormPage(this.service.getNew(request));
    }

    @PostMapping(value={"/last_finished"}, produces={"application/json"})
    @WithRole
    public Page<Map<String, Object>> lastFinished(@RequestBody MagicRequest request) {
        return this.toFormPage(this.service.lastFinished(request));
    }

    @PostMapping(value={"/for_testing"}, produces={"application/json"})
    @WithRole
    public Page<Map<String, Object>> forTesting(@RequestBody MagicRequest request) {
        return this.toFormPage(this.service.forTesting(request));
    }

    @WithRole
    @GetMapping(value={"/byId/{issueId}"}, produces={"application/json"})
    public Map<String, Object> byId(@PathVariable(value="issueId") Long issueId) {
        IssueModel item = (IssueModel)this.getService().findById(issueId).orElseThrow(() -> new ItemNotFoundException(issueId));
        return BeanCopier.values((DefaultForm)this.toForm((BaseEntity)item), (BaseEntity)item, (WebContext.LocalWebContext)this.getContext());
    }

    @WithRole
    @GetMapping(value={"/achieve_tests"}, produces={"application/json"})
    public Page<Map<String, Object>> findByAchieveTests(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="project", required=false) Long project) {
        IssueService issueService = this.getService();
        DefaultSearchSpecification specification = issueService.getAchieveTestSpecification(project);
        Page issueModels = issueService.find(specification, from, limit, page);
        return this.toFormPage(issueModels);
    }

    public Page<Map<String, Object>> toFormPage(Page<IssueModel> page) {
        ArrayList<Map> data = new ArrayList<Map>();
        for (int i = 0; i < page.getContent().size(); ++i) {
            BaseEntity model = (BaseEntity)page.getContent().get(i);
            IssueForm form = (IssueForm)((BeanCopier)this.getBean(BeanCopier.class)).copy((Object)model, IssueForm.class);
            data.add(BeanCopier.values((DefaultForm)form, (BaseEntity)model, (WebContext.LocalWebContext)this.getContext()));
        }
        PageImpl pageList = new PageImpl(data, page.getPageable(), page.getTotalElements());
        return pageList;
    }

    @WithRole
    @PostMapping(value={"/move/{issueId}/{groupId}"}, produces={"application/json"})
    public IssueForm move(@PathVariable Long issueId, @PathVariable Long groupId, @RequestParam Integer condition) {
        IssueModel issue = (IssueModel)((IssueService)this.getContext().getBean(IssueService.class)).findByIdOrThrow(issueId);
        GroupModel group = (GroupModel)((GroupService)this.getContext().getBean(GroupService.class)).findByIdOrThrow(groupId);
        IssueModel move = (IssueModel)((IssueService)this.getContext().getBean(IssueService.class)).move((BaseEntity)issue, group, condition);
        return (IssueForm)this.toForm((BaseEntity)move);
    }

    @WithRole
    @PostMapping(value={"/close/{issueId}"}, produces={"application/json"})
    public IssueForm closeIssue(@PathVariable Long issueId) {
        IssueModel issue = ((IssueService)this.getContext().getBean(IssueService.class)).closeIssue(issueId);
        return (IssueForm)this.toForm((BaseEntity)issue);
    }

    @WithRole(ignoreOnCondition=OpenGroupCondition.class)
    public Page<Map<String, Object>> fetchData(MagicRequest request) {
        OpenGroupCondition condition = (OpenGroupCondition)this.getBean(OpenGroupCondition.class);
        if (condition.checkIgnorePermission(new Object[]{request}, this.getBean(GroupService.class), this.getContext())) {
            return this.fetchDataIgnorePermission(request);
        }
        return super.fetchData(request);
    }

    private Page<Map<String, Object>> fetchDataIgnorePermission(MagicRequest request) {
        DefaultSearchSpecification specification = this.getService().getNotDeletedQuery().specification();
        Specification finalSpecification = this.buildSpecification(specification, request);
        Page res = ((IssueRepo)this.getBean(IssueRepo.class)).findAll(finalSpecification, (Pageable)PageRequest.of((int)request.getPage(), (int)request.getLimit()));
        ArrayList<Map> pageList = new ArrayList<Map>();
        for (int i = 0; i < res.getContent().size(); ++i) {
            IssueModel model = (IssueModel)res.getContent().get(i);
            IssueForm form = (IssueForm)this.toForm((BaseEntity)model);
            pageList.add(BeanCopier.values((DefaultForm)form, (BaseEntity)model, (WebContext.LocalWebContext)this.getContext()));
        }
        return new PageImpl(pageList, res.getPageable(), res.getTotalElements());
    }

    private Specification<IssueModel> buildSpecification(DefaultSearchSpecification<IssueModel> specification, MagicRequest request) {
        QueryCase modifyQuery;
        for (MagicQuery query : request.getQuery()) {
            modifyQuery = this.getService().modifyQuery(query.toQuery(this.getContext()));
            if (Objects.nonNull(modifyQuery)) {
                specification.addCase(modifyQuery);
                continue;
            }
            specification.addCase(query.toQuery(this.getContext()));
        }
        for (MagicQuery query : request.getCases()) {
            modifyQuery = this.getService().modifyQuery((QueryCase)query);
            if (Objects.nonNull(modifyQuery)) {
                specification.addCase(modifyQuery);
                continue;
            }
            specification.addCase((QueryCase)query);
        }
        return specification;
    }

    static {
        SearchEntityApi.registerSearch((String)"issue", (SearcherInfo)new SearcherInfo("name", IssueService.class));
    }
}

