/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller.personal_working_time;

import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.form.personal_working_time.WorkingTimeForm;
import systems.dennis.flaw.model.personal_working_time.WorkingTimeModel;
import systems.dennis.flaw.service.personal_working_time.WorkingTimeService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/working_time"})
@WebFormsSupport(value=WorkingTimeService.class)
@CrossOrigin
public class WorkingTimeController
extends ApplicationContext
implements AddItemController<WorkingTimeModel, WorkingTimeForm>,
EditItemController<WorkingTimeModel, WorkingTimeForm>,
ListItemController<WorkingTimeModel, WorkingTimeForm>,
DeleteItemController {
    public WorkingTimeController(WebContext context) {
        super(context);
    }

    @WithRole
    @GetMapping(value={"/findBy/year/{year}/month/{month}"})
    public ResponseEntity<List<WorkingTimeForm>> getAllByYearAndMonth(@PathVariable(value="year") Integer year, @PathVariable(value="month") Integer month, @RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        List data = this.getService().getAllByYearAndMonth(year, month, from, limit, page);
        return ResponseEntity.ok((Object)this.transformToForm(data));
    }

    @WithRole
    @GetMapping(value={"/findBy/year/{year}/month/{month}/personId/{personId}"})
    public ResponseEntity<List<WorkingTimeForm>> getAllByYearAndMonthAndPerson(@PathVariable(value="year") Integer year, @PathVariable(value="month") Integer month, @PathVariable(value="personId") Long personId, @RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        List data = this.getService().getAllByYearAndMonthAndPersonId(year, month, personId, from, limit, page);
        return ResponseEntity.ok((Object)this.transformToForm(data));
    }

    public WorkingTimeService getService() {
        return (WorkingTimeService)this.getBean(WorkingTimeService.class);
    }

    private List<WorkingTimeForm> transformToForm(List<WorkingTimeModel> models) {
        ArrayList<WorkingTimeForm> result = new ArrayList<WorkingTimeForm>();
        for (WorkingTimeModel item : models) {
            result.add((WorkingTimeForm)this.toForm((BaseEntity)item));
        }
        return result;
    }
}

