/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.controller.statistics;

import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.flaw.model.view.IssueCreatedView;
import systems.dennis.flaw.model.view.IssueStatusView;
import systems.dennis.flaw.repo.IssueCreatedViewRepo;
import systems.dennis.flaw.repo.IssueStatusVewRepo;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@Secured
@CrossOrigin
@RequestMapping(value={"/api/v2/flaw/statistics"})
public class StatisticsController
extends ApplicationContext {
    private IssueCreatedViewRepo repo;
    private IssueStatusVewRepo issueStatusViewRepo;

    public StatisticsController(WebContext context, IssueCreatedViewRepo repo, IssueStatusVewRepo issueStatusViewRepo) {
        super(context);
        this.repo = repo;
        this.issueStatusViewRepo = issueStatusViewRepo;
    }

    @GetMapping(value={"/created"})
    @WithRole
    public Iterable<IssueCreatedView> created() {
        return this.repo.findAll(((GroupService)this.getContext().getBean(GroupService.class)).getAdditionalGroupSpecificationQuery(), Pageable.unpaged()).getContent();
    }

    @GetMapping(value={"/status"})
    @WithRole
    public Iterable<IssueStatusView> status() {
        return this.issueStatusViewRepo.findAll(((GroupService)this.getContext().getBean(GroupService.class)).getAdditionalGroupSpecificationQuery(), Pageable.unpaged()).getContent();
    }
}

