/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.cron;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import systems.dennis.auth.client.entity.UserDataForm;
import systems.dennis.auth.client.remote.AuthClient;
import systems.dennis.flaw.bean.TelegramBotBean;
import systems.dennis.flaw.form.GitBranchForm;
import systems.dennis.flaw.form.GitConfigForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueToGitBranchModel;
import systems.dennis.flaw.repo.GitConfigProjectRepo;
import systems.dennis.flaw.repo.HRRepo;
import systems.dennis.flaw.repo.IssueRepo;
import systems.dennis.flaw.service.CronService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.IssueToGitBranchService;
import systems.dennis.flaw.service.NotificationDeliveryService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@Component
public class Cron
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(Cron.class);
    public static final String GLOBAL_APP_FLAW_SYNC_USER_NAME = "global.app.flaw.sync.user_name";
    public static final String GLOBAL_APP_FLAW_SYNC_PASSWORD = "global.app.flaw.sync.password";
    public static final String SERVERS_AUTH_REQUEST_PATH = "servers.auth.request.path";
    public static final String SERVERS_VERSION_CONTROL_REQUEST_PATH = "servers.version_control.request.path";
    public static final String SCOPE_NAME = "dennis.systems.security.scope.id";
    private static Date lastExecutionDate = null;
    private static Date lastHrSyncDate = null;
    private AuthClient client;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;
    private CronService cronService;

    public Cron(AuthClient client, CronService cronService, WebContext context) {
        super(context);
        this.cronService = cronService;
        this.client = client;
    }

    @Scheduled(fixedDelayString="${app.flaw.user.email.timeout:6000}", initialDelay=6000L)
    public void cronTimeOut() {
        ((NotificationDeliveryService)this.getContext().getBean(NotificationDeliveryService.class)).sendNotification();
    }

    @Scheduled(fixedDelayString="${app.flaw.user.sync.timeout:6000}", initialDelay=6000L)
    public void sync() {
        Date newExecutionDate = new Date();
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null || user.trim().isEmpty()) {
            log.debug("User not set to sync users. HR resources are to be created manually");
            return;
        }
        try {
            String token = this.client.getVirtualToken(user, password).getToken();
            String path = this.getAuthPath() + "/profile/all/scope/" + this.getScope();
            if (lastHrSyncDate != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                String time = dateFormat.format(lastHrSyncDate);
                path = path + "?time=" + time;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Authorization", "Bearer " + token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            UserDataForm[] result = (UserDataForm[])new RestTemplate().exchange(path, HttpMethod.GET, entity, UserDataForm[].class, new Object[0]).getBody();
            HRRepo repo = (HRRepo)this.getBean(HRRepo.class);
            HRService hrService = (HRService)this.getBean(HRService.class);
            for (UserDataForm model : result) {
                HRModel res = new HRModel();
                boolean exists = repo.existsByEmail(model.getEmail());
                if (exists) {
                    res = (HRModel)repo.findOne((Specification)QueryCase.equalsOf((String)"email", (Object)model.getLogin()).specification()).get();
                    Boolean deleted = hrService.isObjectDeleted((BaseEntity)res);
                    if (model.getHiddenBySystem().booleanValue() && !deleted.booleanValue()) {
                        hrService.delete(res.getId());
                        continue;
                    }
                    if (deleted.booleanValue()) continue;
                }
                res.setEmail(model.getEmail());
                res.setDefLanguage(res.getUserSettingModel() == null ? "en" : res.getUserSettingModel().getLanguage());
                res.setRemoteId(model.getId());
                res.setIcon(model.getImagePath());
                res.setName(model.getName());
                res.setLogin(model.getLogin());
                if (exists) {
                    repo.save((Object)res);
                    continue;
                }
                ((HRService)this.getContext().getBean(HRService.class)).save((BaseEntity)res);
            }
            lastHrSyncDate = newExecutionDate;
        }
        catch (Exception e) {
            log.debug("Cannot login or process sync: " + e.getMessage(), (Throwable)e);
        }
    }

    @Scheduled(cron="${time.to.daily.check.cron: 0 0 21 * * *}")
    public void dailyCheck() {
        List groups = this.em.createQuery("from GroupModel").getResultList();
        for (GroupModel groupModel : groups) {
            if (groupModel.getTelegramId() == null) continue;
            StringBuilder message = this.cronService.generateMessageAboutIssuesToGroup(groupModel);
            if (String.valueOf(message).length() != 0) {
                ((TelegramBotBean)this.getContext().getBean(TelegramBotBean.class)).sendMessage(groupModel, String.valueOf(message));
                continue;
            }
            ((TelegramBotBean)this.getContext().getBean(TelegramBotBean.class)).sendMessage(groupModel, "Neither opened nor closed issues today!");
        }
    }

    @Scheduled(fixedDelayString="${app.flaw.branch.sync.timeout:6000}", initialDelay=6000L)
    public void addIssueToGitBranch() {
        Date newExecutionDate = new Date();
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null || user.trim().isEmpty()) {
            log.debug("User not set to sync users.");
            return;
        }
        try {
            String path;
            String token = this.client.getVirtualToken(user, password).getToken();
            if (lastExecutionDate != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                String time = dateFormat.format(lastExecutionDate);
                path = this.getVersionControlPath() + "/git_lab/branch/all?time=" + time;
            } else {
                path = this.getVersionControlPath() + "/git_lab/branch/all";
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Authorization", "Bearer " + token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            GitBranchForm[] results = (GitBranchForm[])new RestTemplate().exchange(path, HttpMethod.GET, entity, GitBranchForm[].class, new Object[0]).getBody();
            IssueRepo issueRepo = (IssueRepo)this.getContext().getBean(IssueRepo.class);
            IssueToGitBranchService issueToGitBranchService = (IssueToGitBranchService)this.getContext().getBean(IssueToGitBranchService.class);
            for (GitBranchForm branch : results) {
                Long issueNumber;
                Optional issue;
                Pattern pattern = Pattern.compile("^\\D*?(\\d+)_.*");
                Matcher matcher = pattern.matcher(branch.getName());
                if (!matcher.matches() || !(issue = issueRepo.findById((Object)(issueNumber = Long.valueOf(Long.parseLong(matcher.group(1)))))).isPresent() || issueToGitBranchService.checkIfDuplicateRelation((IssueModel)issue.get(), branch.getId()) || !this.isAssociationPermitted(headers, (IssueModel)issue.get(), branch.getGitConfig())) continue;
                IssueToGitBranchModel model = new IssueToGitBranchModel();
                model.setIssue((IssueModel)issue.get());
                model.setGitBranch(branch.getId());
                issueToGitBranchService.save((BaseEntity)model);
            }
            lastExecutionDate = newExecutionDate;
        }
        catch (Exception e) {
            log.debug("Cannot login or process sync: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAssociationPermitted(HttpHeaders headers, IssueModel issue, Long configId) {
        if (issue.getProject() == null) {
            return false;
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String path = this.getVersionControlPath() + "/git_lab/config/id/" + configId;
        GitConfigForm gitConfigForm = (GitConfigForm)new RestTemplate().exchange(path, HttpMethod.GET, entity, GitConfigForm.class, new Object[0]).getBody();
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"gitConfigUid", (Object)gitConfigForm.getUid()).specification().addCase(QueryCase.equalsOf((String)"project", (Object)issue.getProject()));
        Optional optional = ((GitConfigProjectRepo)this.getContext().getBean(GitConfigProjectRepo.class)).findOne((Specification)specification);
        return optional.isPresent();
    }

    public String getUser() {
        return (String)this.getContext().getEnv(GLOBAL_APP_FLAW_SYNC_USER_NAME);
    }

    public String getPassword() {
        return (String)this.getContext().getEnv(GLOBAL_APP_FLAW_SYNC_PASSWORD);
    }

    public String getAuthPath() {
        return (String)this.getContext().getEnv(SERVERS_AUTH_REQUEST_PATH);
    }

    public String getVersionControlPath() {
        return (String)this.getContext().getEnv(SERVERS_VERSION_CONTROL_REQUEST_PATH);
    }

    public String getScope() {
        return this.getContext().getEnv(SCOPE_NAME).toString();
    }
}

