/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.form;

import systems.dennis.flaw.service.EpicService;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.StoryFlowService;
import systems.dennis.flaw.service.StoryService;
import systems.dennis.flaw.service.StoryStatusService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;
import systems.dennis.shared.validation.NumberNotZeroValidator;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

@PojoListView(actions={"download", "new", "settings"})
public class StoryForm
implements DefaultForm {
    @PojoFormElement(type="hidden")
    private Long id;
    @PojoFormElement(required=true)
    @PojoListViewField(searchable=true)
    @Validation(value={ValueNotEmptyValidator.class})
    private String name;
    @PojoFormElement(type="date")
    @PojoListViewField(searchable=true, type="date", remote=@Remote(searchType="date"))
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private String start;
    @PojoFormElement(type="date")
    @PojoListViewField(searchable=true, type="date", remote=@Remote(searchType="date"))
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private String finish;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryService.class)
    @PojoFormElement(type="object_chooser", remote=@Remote(fetcher="flaw/story", searchType="object_chooser", searchField="name", searchName="story"))
    @PojoListViewField(type="object_chooser", searchable=true, remote=@Remote(fetcher="flaw/story", searchType="object_chooser", searchField="name", searchName="story"))
    private Long nextStory;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    @PojoFormElement(type="object_chooser", order=10, remote=@Remote(fetcher="flaw/group", searchType="object_chooser", searchField="name", searchName="group"))
    @PojoListViewField(type="object_chooser", searchable=true, visible=false, remote=@Remote(fetcher="flaw/group", searchType="object_chooser", searchField="name", searchName="group"))
    protected Long group;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryStatusService.class)
    @PojoFormElement(type="object_chooser", remote=@Remote(fetcher="flaw/story_status", searchType="object_chooser", searchField="name", searchName="story_status"))
    @PojoListViewField(type="object_chooser", searchable=true, remote=@Remote(fetcher="flaw/story_status", searchType="object_chooser", searchField="name", searchName="story_status"))
    private Long status;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    @PojoFormElement(required=true, type="object_chooser", remote=@Remote(fetcher="flaw/project", searchType="object_chooser", searchField="name", searchName="project"))
    @PojoListViewField(type="object_chooser", searchable=true, remote=@Remote(fetcher="flaw/project", searchType="object_chooser", searchField="name", searchName="project"))
    @Validation(value={NumberNotZeroValidator.class})
    private Long project;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=EpicService.class)
    @PojoFormElement(required=true, type="object_chooser", remote=@Remote(fetcher="flaw/epic", searchType="object_chooser", searchField="name", searchName="epic"))
    @PojoListViewField(type="object_chooser", searchable=true, remote=@Remote(fetcher="flaw/epic", searchType="object_chooser", searchField="name", searchName="epic"))
    @Validation(value={NumberNotZeroValidator.class})
    private Long epic;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryFlowService.class)
    @PojoFormElement(required=true, type="object_chooser", remote=@Remote(fetcher="flaw/story_flow", searchType="object_chooser", searchField="name", searchName="story_flow"))
    @PojoListViewField(type="object_chooser", searchable=true, remote=@Remote(fetcher="flaw/story_flow", searchType="object_chooser", searchField="name", searchName="story_flow"))
    @Validation(value={NumberNotZeroValidator.class})
    private Long storyFlow;
    @PojoListViewField(actions={@UIAction(component="edit"), @UIAction(component="delete", allowOnMultipleRows=true)}, visible=false, sortable=false)
    @PojoFormElement(available=false)
    private Integer action;

    public String asValue() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStart() {
        return this.start;
    }

    public String getFinish() {
        return this.finish;
    }

    public Long getNextStory() {
        return this.nextStory;
    }

    public Long getGroup() {
        return this.group;
    }

    public Long getStatus() {
        return this.status;
    }

    public Long getProject() {
        return this.project;
    }

    public Long getEpic() {
        return this.epic;
    }

    public Long getStoryFlow() {
        return this.storyFlow;
    }

    public Integer getAction() {
        return this.action;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public void setNextStory(Long nextStory) {
        this.nextStory = nextStory;
    }

    public void setGroup(Long group) {
        this.group = group;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public void setEpic(Long epic) {
        this.epic = epic;
    }

    public void setStoryFlow(Long storyFlow) {
        this.storyFlow = storyFlow;
    }

    public void setAction(Integer action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoryForm)) {
            return false;
        }
        StoryForm other = (StoryForm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$nextStory = this.getNextStory();
        Long other$nextStory = other.getNextStory();
        if (this$nextStory == null ? other$nextStory != null : !((Object)this$nextStory).equals(other$nextStory)) {
            return false;
        }
        Long this$group = this.getGroup();
        Long other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        Long this$status = this.getStatus();
        Long other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Long this$project = this.getProject();
        Long other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        Long this$epic = this.getEpic();
        Long other$epic = other.getEpic();
        if (this$epic == null ? other$epic != null : !((Object)this$epic).equals(other$epic)) {
            return false;
        }
        Long this$storyFlow = this.getStoryFlow();
        Long other$storyFlow = other.getStoryFlow();
        if (this$storyFlow == null ? other$storyFlow != null : !((Object)this$storyFlow).equals(other$storyFlow)) {
            return false;
        }
        Integer this$action = this.getAction();
        Integer other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        String this$finish = this.getFinish();
        String other$finish = other.getFinish();
        return !(this$finish == null ? other$finish != null : !this$finish.equals(other$finish));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoryForm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $nextStory = this.getNextStory();
        result = result * 59 + ($nextStory == null ? 43 : ((Object)$nextStory).hashCode());
        Long $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        Long $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Long $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        Long $epic = this.getEpic();
        result = result * 59 + ($epic == null ? 43 : ((Object)$epic).hashCode());
        Long $storyFlow = this.getStoryFlow();
        result = result * 59 + ($storyFlow == null ? 43 : ((Object)$storyFlow).hashCode());
        Integer $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        String $finish = this.getFinish();
        result = result * 59 + ($finish == null ? 43 : $finish.hashCode());
        return result;
    }

    public String toString() {
        return "StoryForm(id=" + this.getId() + ", name=" + this.getName() + ", start=" + this.getStart() + ", finish=" + this.getFinish() + ", nextStory=" + this.getNextStory() + ", group=" + this.getGroup() + ", status=" + this.getStatus() + ", project=" + this.getProject() + ", epic=" + this.getEpic() + ", storyFlow=" + this.getStoryFlow() + ", action=" + this.getAction() + ")";
    }
}

