/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.exception.EmailSendingException;
import systems.dennis.shared.utils.SimpleEvaluator;

@Component
public class MailSender {
    private static final Logger log = LoggerFactory.getLogger(MailSender.class);
    private final Environment environment;
    @Value(value="${spring.mail.host}")
    private String host;
    @Value(value="${spring.mail.port}")
    private int port;
    @Value(value="${spring.mail.username}")
    private String username;
    @Value(value="${spring.mail.password}")
    private String password;
    @Value(value="${spring.mail.properties.mail.smtp.auth}")
    private boolean auth;
    @Value(value="${spring.mail.properties.mail.smtp.starttls.enable}")
    private boolean starttls;

    public MailSender(Environment environment) {
        this.environment = environment;
    }

    public void sendMail(List<String> recipients, String body, String title) {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.host);
        properties.put("mail.smtp.port", (Object)this.port);
        properties.put("mail.smtp.auth", (Object)this.auth);
        properties.put("mail.smtp.starttls.enable", (Object)this.starttls);
        Session session = Session.getInstance((Properties)properties, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        session.setDebug(true);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.username));
            ArrayList<InternetAddress> recipientAddresses = new ArrayList<InternetAddress>();
            for (String recipient : recipients) {
                recipientAddresses.add(new InternetAddress(recipient));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
            message.setSubject(title);
            message.setContent((Object)body, "text/html; charset=UTF-8");
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            log.error("Error sending email");
            throw new EmailSendingException((Serializable)((Object)e), "Error sending email");
        }
    }

    public String processHtmlTemplate(String path, Map<String, Object> params) {
        HashMap<String, String> stringParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            stringParams.put(entry.getKey(), entry.getValue().toString());
        }
        try {
            ClassPathResource resource = new ClassPathResource("mail-templates/" + path);
            InputStream inputStream = resource.getInputStream();
            String html = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            SimpleEvaluator evaluator = new SimpleEvaluator(this.environment);
            return evaluator.evaluate(html, 0, stringParams);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process HTML template: " + path, e);
        }
    }
}

