/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import java.util.List;
import systems.dennis.flaw.model.DemoModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.IssueBoardStatusModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.IssueFlowService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.BeanCopierListTransformer;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class BoardModel
extends UserAssignableEntity
implements GroupableModel,
DemoModel {
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueFlowService.class)
    private IssueFlowModel flow;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    private GroupModel group;
    private String name;
    private String color;
    @ManyToMany(cascade={CascadeType.ALL})
    @DataTransformer(transFormWith=BeanCopierListTransformer.class, additionalClass=IssueBoardStatusModel.class)
    @ObjectByIdPresentation
    private List<IssueBoardStatusModel> statuses;
    private Boolean demo;
    private String demoData;

    public GroupModel findInnerGroup() {
        return this.flow.getGroup();
    }

    public IssueFlowModel getFlow() {
        return this.flow;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public List<IssueBoardStatusModel> getStatuses() {
        return this.statuses;
    }

    public Boolean getDemo() {
        return this.demo;
    }

    public String getDemoData() {
        return this.demoData;
    }

    public void setFlow(IssueFlowModel flow) {
        this.flow = flow;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setStatuses(List<IssueBoardStatusModel> statuses) {
        this.statuses = statuses;
    }

    public void setDemo(Boolean demo) {
        this.demo = demo;
    }

    public void setDemoData(String demoData) {
        this.demoData = demoData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoardModel)) {
            return false;
        }
        BoardModel other = (BoardModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$demo = this.getDemo();
        Boolean other$demo = other.getDemo();
        if (this$demo == null ? other$demo != null : !((Object)this$demo).equals(other$demo)) {
            return false;
        }
        IssueFlowModel this$flow = this.getFlow();
        IssueFlowModel other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        List this$statuses = this.getStatuses();
        List other$statuses = other.getStatuses();
        if (this$statuses == null ? other$statuses != null : !((Object)this$statuses).equals(other$statuses)) {
            return false;
        }
        String this$demoData = this.getDemoData();
        String other$demoData = other.getDemoData();
        return !(this$demoData == null ? other$demoData != null : !this$demoData.equals(other$demoData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoardModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $demo = this.getDemo();
        result = result * 59 + ($demo == null ? 43 : ((Object)$demo).hashCode());
        IssueFlowModel $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        List $statuses = this.getStatuses();
        result = result * 59 + ($statuses == null ? 43 : ((Object)$statuses).hashCode());
        String $demoData = this.getDemoData();
        result = result * 59 + ($demoData == null ? 43 : $demoData.hashCode());
        return result;
    }

    public String toString() {
        return "BoardModel(flow=" + String.valueOf(this.getFlow()) + ", group=" + String.valueOf(this.getGroup()) + ", name=" + this.getName() + ", color=" + this.getColor() + ", statuses=" + String.valueOf(this.getStatuses()) + ", demo=" + this.getDemo() + ", demoData=" + this.getDemoData() + ")";
    }
}

