/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class CommentModel
extends UserAssignableEntity {
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    @ObjectByIdPresentation
    @OneToOne
    @FormTransient
    private HRModel hr;
    @Column(columnDefinition="text")
    private String text;
    @ElementCollection
    private List<String> attachments = new ArrayList();
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"HH:mm:ss dd.MM.yyyy"})
    private Date date;
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    @ObjectByIdPresentation
    @OneToOne
    private IssueModel issue;
    @Transient
    private Long userId;

    public HRModel getHr() {
        return this.hr;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getAttachments() {
        return this.attachments;
    }

    public Date getDate() {
        return this.date;
    }

    public IssueModel getIssue() {
        return this.issue;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setHr(HRModel hr) {
        this.hr = hr;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentModel)) {
            return false;
        }
        CommentModel other = (CommentModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        HRModel this$hr = this.getHr();
        HRModel other$hr = other.getHr();
        if (this$hr == null ? other$hr != null : !this$hr.equals(other$hr)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List this$attachments = this.getAttachments();
        List other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        return !(this$issue == null ? other$issue != null : !this$issue.equals(other$issue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommentModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        HRModel $hr = this.getHr();
        result = result * 59 + ($hr == null ? 43 : $hr.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        return result;
    }

    public String toString() {
        return "CommentModel(hr=" + String.valueOf(this.getHr()) + ", text=" + this.getText() + ", attachments=" + String.valueOf(this.getAttachments()) + ", date=" + String.valueOf(this.getDate()) + ", issue=" + String.valueOf(this.getIssue()) + ", userId=" + this.getUserId() + ")";
    }
}

