/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.annotation.MoveField;
import systems.dennis.flaw.model.EpicFlowModel;
import systems.dennis.flaw.model.EpicStatusModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.service.EpicFlowService;
import systems.dennis.flaw.service.EpicStatusService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class EpicModel
extends UserAssignableEntity
implements GroupableModel {
    @MoveField
    private String name;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    @MoveField
    private Date start;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    @MoveField
    private Date finish;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=EpicStatusService.class)
    @MoveField
    private EpicStatusModel status;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    @MoveField
    public ProjectModel project;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=EpicFlowService.class)
    @MoveField(createPolicy=2)
    private EpicFlowModel epicFlow;
    @OneToOne
    @FormTransient
    private GroupModel group;

    public String asValue() {
        return this.name;
    }

    public GroupModel findInnerGroup() {
        if (this.project != null) {
            return this.project.getGroup();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getFinish() {
        return this.finish;
    }

    public EpicStatusModel getStatus() {
        return this.status;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public EpicFlowModel getEpicFlow() {
        return this.epicFlow;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setFinish(Date finish) {
        this.finish = finish;
    }

    public void setStatus(EpicStatusModel status) {
        this.status = status;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setEpicFlow(EpicFlowModel epicFlow) {
        this.epicFlow = epicFlow;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EpicModel)) {
            return false;
        }
        EpicModel other = (EpicModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$finish = this.getFinish();
        Date other$finish = other.getFinish();
        if (this$finish == null ? other$finish != null : !((Object)this$finish).equals(other$finish)) {
            return false;
        }
        EpicStatusModel this$status = this.getStatus();
        EpicStatusModel other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        EpicFlowModel this$epicFlow = this.getEpicFlow();
        EpicFlowModel other$epicFlow = other.getEpicFlow();
        if (this$epicFlow == null ? other$epicFlow != null : !this$epicFlow.equals(other$epicFlow)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EpicModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $finish = this.getFinish();
        result = result * 59 + ($finish == null ? 43 : ((Object)$finish).hashCode());
        EpicStatusModel $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        EpicFlowModel $epicFlow = this.getEpicFlow();
        result = result * 59 + ($epicFlow == null ? 43 : $epicFlow.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "EpicModel(name=" + this.getName() + ", start=" + String.valueOf(this.getStart()) + ", finish=" + String.valueOf(this.getFinish()) + ", status=" + String.valueOf(this.getStatus()) + ", project=" + String.valueOf(this.getProject()) + ", epicFlow=" + String.valueOf(this.getEpicFlow()) + ", group=" + String.valueOf(this.getGroup()) + ")";
    }
}

