/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.IssueStatusService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class IssueFlowHistoryModel
extends UserAssignableEntity {
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel issue;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueStatusService.class)
    private IssueStatusModel from;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueStatusService.class)
    private IssueStatusModel to;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel performer;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date date = new Date();

    public IssueModel getIssue() {
        return this.issue;
    }

    public IssueStatusModel getFrom() {
        return this.from;
    }

    public IssueStatusModel getTo() {
        return this.to;
    }

    public HRModel getPerformer() {
        return this.performer;
    }

    public Date getDate() {
        return this.date;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public void setFrom(IssueStatusModel from) {
        this.from = from;
    }

    public void setTo(IssueStatusModel to) {
        this.to = to;
    }

    public void setPerformer(HRModel performer) {
        this.performer = performer;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueFlowHistoryModel)) {
            return false;
        }
        IssueFlowHistoryModel other = (IssueFlowHistoryModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        if (this$issue == null ? other$issue != null : !this$issue.equals(other$issue)) {
            return false;
        }
        IssueStatusModel this$from = this.getFrom();
        IssueStatusModel other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        IssueStatusModel this$to = this.getTo();
        IssueStatusModel other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        HRModel this$performer = this.getPerformer();
        HRModel other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueFlowHistoryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        IssueStatusModel $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        IssueStatusModel $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        HRModel $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "IssueFlowHistoryModel(issue=" + String.valueOf(this.getIssue()) + ", from=" + String.valueOf(this.getFrom()) + ", to=" + String.valueOf(this.getTo()) + ", performer=" + String.valueOf(this.getPerformer()) + ", date=" + String.valueOf(this.getDate()) + ")";
    }
}

