/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.List;
import net.minidev.json.annotate.JsonIgnore;
import systems.dennis.flaw.model.DemoModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.model.IssueTypeModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.IssueFlowStageService;
import systems.dennis.flaw.service.IssueTypeService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.BeanCopierListTransformer;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class IssueFlowModel
extends UserAssignableEntity
implements GroupableModel,
DemoModel {
    private String name;
    @OneToMany(cascade={CascadeType.ALL})
    @DataTransformer(transFormWith=BeanCopierListTransformer.class, additionalClass=IssueFlowStageService.class)
    private List<IssueFlowStageModel> stages;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueTypeService.class)
    private IssueTypeModel issueType;
    @ManyToOne(fetch=FetchType.LAZY)
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    @JsonIgnore
    protected GroupModel group;
    private Boolean demo = false;
    private String demoData;

    public String asValue() {
        return this.name;
    }

    public GroupModel findInnerGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public List<IssueFlowStageModel> getStages() {
        return this.stages;
    }

    public IssueTypeModel getIssueType() {
        return this.issueType;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public Boolean getDemo() {
        return this.demo;
    }

    public String getDemoData() {
        return this.demoData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStages(List<IssueFlowStageModel> stages) {
        this.stages = stages;
    }

    public void setIssueType(IssueTypeModel issueType) {
        this.issueType = issueType;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setDemo(Boolean demo) {
        this.demo = demo;
    }

    public void setDemoData(String demoData) {
        this.demoData = demoData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueFlowModel)) {
            return false;
        }
        IssueFlowModel other = (IssueFlowModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$demo = this.getDemo();
        Boolean other$demo = other.getDemo();
        if (this$demo == null ? other$demo != null : !((Object)this$demo).equals(other$demo)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$stages = this.getStages();
        List other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        IssueTypeModel this$issueType = this.getIssueType();
        IssueTypeModel other$issueType = other.getIssueType();
        if (this$issueType == null ? other$issueType != null : !this$issueType.equals(other$issueType)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$demoData = this.getDemoData();
        String other$demoData = other.getDemoData();
        return !(this$demoData == null ? other$demoData != null : !this$demoData.equals(other$demoData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueFlowModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $demo = this.getDemo();
        result = result * 59 + ($demo == null ? 43 : ((Object)$demo).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        IssueTypeModel $issueType = this.getIssueType();
        result = result * 59 + ($issueType == null ? 43 : $issueType.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $demoData = this.getDemoData();
        result = result * 59 + ($demoData == null ? 43 : $demoData.hashCode());
        return result;
    }

    public String toString() {
        return "IssueFlowModel(name=" + this.getName() + ", stages=" + String.valueOf(this.getStages()) + ", issueType=" + String.valueOf(this.getIssueType()) + ", demo=" + this.getDemo() + ", demoData=" + this.getDemoData() + ")";
    }
}

