/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class IssueHistoryModel
extends UserAssignableEntity {
    private String field;
    private String action;
    @Column(name="from_value")
    private String from;
    @Column(name="to_value")
    private String to;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date date;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel performer;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel issue;

    public String getField() {
        return this.field;
    }

    public String getAction() {
        return this.action;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Date getDate() {
        return this.date;
    }

    public HRModel getPerformer() {
        return this.performer;
    }

    public IssueModel getIssue() {
        return this.issue;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setPerformer(HRModel performer) {
        this.performer = performer;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueHistoryModel)) {
            return false;
        }
        IssueHistoryModel other = (IssueHistoryModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        HRModel this$performer = this.getPerformer();
        HRModel other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        return !(this$issue == null ? other$issue != null : !this$issue.equals(other$issue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueHistoryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        HRModel $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        return result;
    }

    public String toString() {
        return "IssueHistoryModel(field=" + this.getField() + ", action=" + this.getAction() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", date=" + String.valueOf(this.getDate()) + ", performer=" + String.valueOf(this.getPerformer()) + ", issue=" + String.valueOf(this.getIssue()) + ")";
    }
}

